<?php

    /**
     * 状态码说明
     * 200 成功
     * 201 失败
     * 202 空值
     * 203 无结果
     * The Code By TANKING In 2022/11/11
     * Blog：https://segmentfault.com/u/tanking
     */

	// 页面编码
	header("Content-type:application/json");

    // 请求地址（请查看开发文档将请求地址填写于此）
    $reqUrl = '请查看开发文档将请求地址填写于此';
    
    // 请求接口常量（请查看开发文档将ApiKey和ApiSecrete填写于此）
    // --------------------------------------------------
    define("api_key","请查看开发文档将ApiKey填写于此"); // 开放接口ApiKey（ApiKey）
    define("api_secrete","请查看开发文档将ApiSecrete填写于此"); // 开放接口密钥（ApiSecrete）
    
    // 创建短网址所需的配置参数
    // 下面可以改成$_POST['name']来接收表单
    // 例如接收表单的name=dwz_title输入的数据
    // $dwz_title = trim($_POST['dwz_title']);
    // -------------------------------------
    $dwz_title = '短网址Api测试'; // 标题（尽量简短）
    $dwz_dlws = 5; // Key位数（建议按需填4、5、6）
    $dwz_type = 1; // 访问限制（1不限制，其它请阅读开发文档）
    $dwz_url = 'http://www.baidu.com/1-2-3-4-5-6-7-8-9-10.html'; // 目标链接（点击短网址后最终跳转到的链接）
    
    // 将所有需要请求Api的参数写成数组
    // 后续便于转换为JSON发送给请求地址
    // ------------------------------------
    $reqParams = array(
        'dwz_title' => $dwz_title,
        'dwz_dlws' => $dwz_dlws,
        'dwz_type' => $dwz_type,
        'dwz_url' => $dwz_url,
        'api_key' => constant("api_key"),
        'sign' => getSignature($dwz_title,$dwz_type,$dwz_url,constant("api_key"),constant("api_secrete")) // 签名
    );
    
    // 调用并返回调用结果
    echo curlRequest($reqUrl,$reqParams);
    
    // // 如需解析调用结果请使用下方的
    // $curlRequestResult = curlRequest($reqUrl,$reqParams);
    // // 解析code（调用结果状态码）
    // $code = json_decode($curlRequestResult)->code;
    // // 解析msg（调用结果返回的状态信息）
    // $msg = json_decode($curlRequestResult)->msg;
    // // 解析url（短网址）
    // $url = json_decode($curlRequestResult)->url;
    // // 输出解析结果
    // echo $url;
    
    // 传入请求地址和请求参数
    function curlRequest($reqUrl,$reqParams){
        
        // 发送CURL请求
        $curl = curl_init($reqUrl);
        curl_setopt($curl, CURLOPT_HEADER, false);
        curl_setopt($curl, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($curl, CURLOPT_HTTPHEADER, array("Content-type: application/json"));
        curl_setopt($curl, CURLOPT_POST, true);
        curl_setopt($curl, CURLOPT_POSTFIELDS, json_encode($reqParams, JSON_UNESCAPED_UNICODE));
        return curl_exec($curl);
        curl_close($curl);
    }
    
    // 签名算法
    function getSignature($dwz_title,$dwz_type,$dwz_url,$api_key,$api_secrete){
        
        // dwz_title、dwz_type、dwz_url、api_key、api_secrete
        // 按顺序连接后进行MD5加密
        return MD5($dwz_title.$dwz_type.$dwz_url.$api_key.$api_secrete);
    }

?>