/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.ir.analysis.constant;

import com.android.tools.r8.ir.analysis.constant.Bottom;
import com.android.tools.r8.ir.analysis.constant.LatticeElement;
import com.android.tools.r8.ir.code.Value;

public class ConstRangeLatticeElement
extends LatticeElement {
    private final Value value;

    public ConstRangeLatticeElement(Value value) {
        assert (value.hasValueRange());
        this.value = value;
    }

    @Override
    public LatticeElement meet(LatticeElement other) {
        if (other.isTop()) {
            return this;
        }
        if (other.isBottom()) {
            return other;
        }
        if (other.isValueRange()) {
            ConstRangeLatticeElement otherRange = other.asConstRange();
            if (this.getConstRange().getValueRange().equals(otherRange.getConstRange().getValueRange())) {
                return this;
            }
        }
        return Bottom.getInstance();
    }

    @Override
    public boolean isValueRange() {
        return true;
    }

    public String toString() {
        return this.value.toString();
    }

    public Value getConstRange() {
        return this.value;
    }

    @Override
    public ConstRangeLatticeElement asConstRange() {
        return this;
    }
}

