/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.code;

import com.android.tools.r8.ApiLevelException;
import com.android.tools.r8.code.BytecodeStream;
import com.android.tools.r8.code.Format21c;
import com.android.tools.r8.errors.InternalCompilerError;
import com.android.tools.r8.graph.DexMethodHandle;
import com.android.tools.r8.graph.ObjectToOffsetMapping;
import com.android.tools.r8.graph.OffsetToObjectMapping;
import com.android.tools.r8.graph.UseRegistry;
import com.android.tools.r8.ir.conversion.IRBuilder;
import com.android.tools.r8.naming.ClassNameMapper;
import java.nio.ShortBuffer;

public class ConstMethodHandle
extends Format21c {
    public static final int OPCODE = 254;
    public static final String NAME = "ConstMethodHandle";
    public static final String SMALI_NAME = "const-method-handle";

    ConstMethodHandle(int high, BytecodeStream stream, OffsetToObjectMapping mapping) {
        super(high, stream, mapping.getMethodHandleMap());
    }

    public ConstMethodHandle(int register, DexMethodHandle methodHandle) {
        super(register, methodHandle);
    }

    public DexMethodHandle getMethodHandle() {
        return (DexMethodHandle)this.BBBB;
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public String getSmaliName() {
        return SMALI_NAME;
    }

    @Override
    public int getOpcode() {
        return 254;
    }

    @Override
    public String toString(ClassNameMapper naming) {
        return this.formatString("v" + this.AA + ", \"" + this.BBBB.toString() + "\"");
    }

    @Override
    public String toSmaliString(ClassNameMapper naming) {
        return this.formatSmaliString("v" + this.AA + ", \"" + this.BBBB.toString() + "\"");
    }

    @Override
    public void registerUse(UseRegistry registry) {
        registry.registerMethodHandle(this.getMethodHandle());
    }

    @Override
    public void write(ShortBuffer dest, ObjectToOffsetMapping mapping) {
        int index = this.BBBB.getOffset(mapping);
        if (index != (index & 0xFFFF)) {
            throw new InternalCompilerError("MethodHandle-index overflow.");
        }
        super.write(dest, mapping);
    }

    @Override
    public void buildIR(IRBuilder builder) throws ApiLevelException {
        builder.addConstMethodHandle(this.AA, (DexMethodHandle)this.BBBB);
    }

    @Override
    public boolean canThrow() {
        return true;
    }
}

