/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.smali.baksmali.Adaptors;

import com.android.tools.smali.baksmali.Adaptors.AnnotationFormatter;
import com.android.tools.smali.baksmali.Adaptors.CommentingIndentingWriter;
import com.android.tools.smali.baksmali.Adaptors.FieldDefinition;
import com.android.tools.smali.baksmali.Adaptors.MethodDefinition;
import com.android.tools.smali.baksmali.BaksmaliOptions;
import com.android.tools.smali.baksmali.formatter.BaksmaliFormatter;
import com.android.tools.smali.baksmali.formatter.BaksmaliWriter;
import com.android.tools.smali.dexlib2.AccessFlags;
import com.android.tools.smali.dexlib2.dexbacked.DexBackedClassDef;
import com.android.tools.smali.dexlib2.iface.Annotation;
import com.android.tools.smali.dexlib2.iface.ClassDef;
import com.android.tools.smali.dexlib2.iface.Field;
import com.android.tools.smali.dexlib2.iface.Method;
import com.android.tools.smali.dexlib2.iface.MethodImplementation;
import com.android.tools.smali.dexlib2.iface.instruction.Instruction;
import com.android.tools.smali.dexlib2.iface.instruction.formats.Instruction21c;
import com.android.tools.smali.dexlib2.iface.reference.FieldReference;
import com.android.tools.smali.dexlib2.iface.reference.Reference;
import java.io.IOException;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class ClassDefinition {
    public final BaksmaliOptions options;
    public final ClassDef classDef;
    private final HashSet<String> fieldsSetInStaticConstructor;
    private final BaksmaliFormatter formatter;

    public ClassDefinition(BaksmaliOptions options, ClassDef classDef) {
        this.options = options;
        this.classDef = classDef;
        this.formatter = new BaksmaliFormatter(options.implicitReferences ? classDef.getType() : null);
        this.fieldsSetInStaticConstructor = this.findFieldsSetInStaticConstructor(classDef);
    }

    private HashSet<String> findFieldsSetInStaticConstructor(ClassDef classDef) {
        HashSet<String> fieldsSetInStaticConstructor = new HashSet<String>();
        for (Method method : classDef.getDirectMethods()) {
            MethodImplementation impl;
            if (!method.getName().equals("<clinit>") || (impl = method.getImplementation()) == null) continue;
            block6: for (Instruction instruction : impl.getInstructions()) {
                switch (instruction.getOpcode()) {
                    case SPUT: 
                    case SPUT_BOOLEAN: 
                    case SPUT_BYTE: 
                    case SPUT_CHAR: 
                    case SPUT_OBJECT: 
                    case SPUT_SHORT: 
                    case SPUT_WIDE: {
                        Instruction21c ins = (Instruction21c)instruction;
                        FieldReference fieldRef = (FieldReference)ins.getReference();
                        try {
                            fieldRef.validateReference();
                            if (!fieldRef.getDefiningClass().equals(classDef.getType())) continue block6;
                            fieldsSetInStaticConstructor.add(this.formatter.getShortFieldDescriptor(fieldRef));
                        }
                        catch (Reference.InvalidReferenceException invalidReferenceException) {}
                        break;
                    }
                }
            }
        }
        return fieldsSetInStaticConstructor;
    }

    public void writeTo(BaksmaliWriter writer) throws IOException {
        this.writeClass(writer);
        this.writeSuper(writer);
        this.writeSourceFile(writer);
        this.writeInterfaces(writer);
        this.writeAnnotations(writer);
        Set<String> staticFields = this.writeStaticFields(writer);
        this.writeInstanceFields(writer, staticFields);
        Set<String> directMethods = this.writeDirectMethods(writer);
        this.writeVirtualMethods(writer, directMethods);
    }

    private void writeClass(BaksmaliWriter writer) throws IOException {
        writer.write(".class ");
        this.writeAccessFlags(writer);
        writer.writeType(this.classDef.getType());
        writer.write(10);
    }

    private void writeAccessFlags(BaksmaliWriter writer) throws IOException {
        for (AccessFlags accessFlag : AccessFlags.getAccessFlagsForClass(this.classDef.getAccessFlags())) {
            writer.write(accessFlag.toString());
            writer.write(32);
        }
    }

    private void writeSuper(BaksmaliWriter writer) throws IOException {
        String superClass = this.classDef.getSuperclass();
        if (superClass != null) {
            writer.write(".super ");
            writer.writeType(superClass);
            writer.write(10);
        }
    }

    private void writeSourceFile(BaksmaliWriter writer) throws IOException {
        String sourceFile = this.classDef.getSourceFile();
        if (sourceFile != null) {
            writer.write(".source ");
            writer.writeQuotedString(sourceFile);
            writer.write("\n");
        }
    }

    private void writeInterfaces(BaksmaliWriter writer) throws IOException {
        List<String> interfaces = this.classDef.getInterfaces();
        if (interfaces.size() != 0) {
            writer.write(10);
            writer.write("# interfaces\n");
            for (String interfaceName : interfaces) {
                writer.write(".implements ");
                writer.writeType(interfaceName);
                writer.write(10);
            }
        }
    }

    private void writeAnnotations(BaksmaliWriter writer) throws IOException {
        Set<? extends Annotation> classAnnotations = this.classDef.getAnnotations();
        if (classAnnotations.size() != 0) {
            writer.write("\n\n");
            writer.write("# annotations\n");
            AnnotationFormatter.writeTo(writer, classAnnotations);
        }
    }

    private Set<String> writeStaticFields(BaksmaliWriter writer) throws IOException {
        boolean wroteHeader = false;
        HashSet<String> writtenFields = new HashSet<String>();
        Iterable<? extends Field> staticFields = this.classDef instanceof DexBackedClassDef ? ((DexBackedClassDef)this.classDef).getStaticFields(false) : this.classDef.getStaticFields();
        for (Field field : staticFields) {
            boolean setInStaticConstructor;
            if (!wroteHeader) {
                writer.write("\n\n");
                writer.write("# static fields");
                wroteHeader = true;
            }
            writer.write(10);
            BaksmaliWriter fieldWriter = writer;
            String fieldString = this.formatter.getShortFieldDescriptor(field);
            if (!writtenFields.add(fieldString)) {
                writer.write("# duplicate field ignored\n");
                fieldWriter = this.getCommentingWriter(writer);
                System.err.println(String.format("Ignoring duplicate field: %s->%s", this.classDef.getType(), fieldString));
                setInStaticConstructor = false;
            } else {
                setInStaticConstructor = this.fieldsSetInStaticConstructor.contains(fieldString);
            }
            FieldDefinition.writeTo(fieldWriter, field, setInStaticConstructor);
        }
        return writtenFields;
    }

    private void writeInstanceFields(BaksmaliWriter writer, Set<String> staticFields) throws IOException {
        boolean wroteHeader = false;
        HashSet<String> writtenFields = new HashSet<String>();
        Iterable<? extends Field> instanceFields = this.classDef instanceof DexBackedClassDef ? ((DexBackedClassDef)this.classDef).getInstanceFields(false) : this.classDef.getInstanceFields();
        for (Field field : instanceFields) {
            if (!wroteHeader) {
                writer.write("\n\n");
                writer.write("# instance fields");
                wroteHeader = true;
            }
            writer.write(10);
            BaksmaliWriter fieldWriter = writer;
            String fieldString = this.formatter.getShortFieldDescriptor(field);
            if (!writtenFields.add(fieldString)) {
                writer.write("# duplicate field ignored\n");
                fieldWriter = this.getCommentingWriter(writer);
                System.err.println(String.format("Ignoring duplicate field: %s->%s", this.classDef.getType(), fieldString));
            } else if (staticFields.contains(fieldString)) {
                System.err.println(String.format("Duplicate static+instance field found: %s->%s", this.classDef.getType(), fieldString));
                System.err.println("You will need to rename one of these fields, including all references.");
                writer.write("# There is both a static and instance field with this signature.\n# You will need to rename one of these fields, including all references.\n");
            }
            FieldDefinition.writeTo(fieldWriter, field, false);
        }
    }

    private Set<String> writeDirectMethods(BaksmaliWriter writer) throws IOException {
        boolean wroteHeader = false;
        HashSet<String> writtenMethods = new HashSet<String>();
        Iterable<? extends Method> directMethods = this.classDef instanceof DexBackedClassDef ? ((DexBackedClassDef)this.classDef).getDirectMethods(false) : this.classDef.getDirectMethods();
        for (Method method : directMethods) {
            MethodImplementation methodImpl;
            if (!wroteHeader) {
                writer.write("\n\n");
                writer.write("# direct methods");
                wroteHeader = true;
            }
            writer.write(10);
            String methodString = this.formatter.getShortMethodDescriptor(method);
            BaksmaliWriter methodWriter = writer;
            if (!writtenMethods.add(methodString)) {
                writer.write("# duplicate method ignored\n");
                methodWriter = this.getCommentingWriter(writer);
            }
            if ((methodImpl = method.getImplementation()) == null) {
                MethodDefinition.writeEmptyMethodTo(methodWriter, method, this);
                continue;
            }
            MethodDefinition methodDefinition = new MethodDefinition(this, method, methodImpl);
            methodDefinition.writeTo(methodWriter);
        }
        return writtenMethods;
    }

    private void writeVirtualMethods(BaksmaliWriter writer, Set<String> directMethods) throws IOException {
        boolean wroteHeader = false;
        HashSet<String> writtenMethods = new HashSet<String>();
        Iterable<? extends Method> virtualMethods = this.classDef instanceof DexBackedClassDef ? ((DexBackedClassDef)this.classDef).getVirtualMethods(false) : this.classDef.getVirtualMethods();
        for (Method method : virtualMethods) {
            if (!wroteHeader) {
                writer.write("\n\n");
                writer.write("# virtual methods");
                wroteHeader = true;
            }
            writer.write(10);
            String methodString = this.formatter.getShortMethodDescriptor(method);
            BaksmaliWriter methodWriter = writer;
            if (!writtenMethods.add(methodString)) {
                writer.write("# duplicate method ignored\n");
                methodWriter = this.getCommentingWriter(writer);
            } else if (directMethods.contains(methodString)) {
                writer.write("# There is both a direct and virtual method with this signature.\n# You will need to rename one of these methods, including all references.\n");
                System.err.println(String.format("Duplicate direct+virtual method found: %s->%s", this.classDef.getType(), methodString));
                System.err.println("You will need to rename one of these methods, including all references.");
            }
            MethodImplementation methodImpl = method.getImplementation();
            if (methodImpl == null) {
                MethodDefinition.writeEmptyMethodTo(methodWriter, method, this);
                continue;
            }
            MethodDefinition methodDefinition = new MethodDefinition(this, method, methodImpl);
            methodDefinition.writeTo(methodWriter);
        }
    }

    public BaksmaliWriter getCommentingWriter(BaksmaliWriter writer) {
        return this.formatter.getWriter(new CommentingIndentingWriter(writer.indentingWriter()));
    }

    public BaksmaliFormatter getFormatter() {
        return this.formatter;
    }
}

