/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.file;

import java.io.IOException;
import java.nio.file.AccessDeniedException;
import java.nio.file.CopyOption;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.DosFileAttributeView;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.PosixFileAttributes;
import java.nio.file.attribute.PosixFilePermission;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Stream;
import org.apache.commons.io.file.Counters$LongCounter;
import org.apache.commons.io.file.Counters$LongPathCounters;
import org.apache.commons.io.file.DeleteOption;
import org.apache.commons.io.file.StandardDeleteOption;

public abstract class PathUtils {
    public static final LinkOption[] EMPTY_LINK_OPTION_ARRAY;
    public static final LinkOption[] NOFOLLOW_LINK_OPTION_ARRAY;

    public static String getFileNameString(Path path) {
        Function<Path, String> function = Path::toString;
        path = path != null ? path.getFileName() : null;
        return path != null ? function.apply(path) : null;
    }

    public static LinkOption[] noFollowLinkOptionArray() {
        return (LinkOption[])NOFOLLOW_LINK_OPTION_ARRAY.clone();
    }

    public static boolean overrideReadOnly(DeleteOption ... deleteOptionArray) {
        return Stream.of(deleteOptionArray).anyMatch(deleteOption -> deleteOption == StandardDeleteOption.OVERRIDE_READ_ONLY);
    }

    static {
        OpenOption[] cfr_ignored_0 = new OpenOption[2];
        OpenOption[] cfr_ignored_1 = new OpenOption[2];
        CopyOption[] cfr_ignored_2 = new CopyOption[0];
        FileAttribute[] cfr_ignored_3 = new FileAttribute[0];
        FileVisitOption[] cfr_ignored_4 = new FileVisitOption[0];
        EMPTY_LINK_OPTION_ARRAY = new LinkOption[0];
        NOFOLLOW_LINK_OPTION_ARRAY = new LinkOption[]{LinkOption.NOFOLLOW_LINKS};
        OpenOption[] cfr_ignored_5 = new OpenOption[0];
        Path[] cfr_ignored_6 = new Path[0];
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Counters$LongPathCounters deleteFile(Path path, LinkOption[] linkOptionArray, DeleteOption ... object) {
        Throwable throwable2;
        PosixFileAttributes posixFileAttributes;
        block16: {
            Counters$LongPathCounters counters$LongPathCounters;
            block13: {
                Object object2;
                block15: {
                    block14: {
                        Counters$LongPathCounters counters$LongPathCounters2;
                        if (Files.isDirectory(path, linkOptionArray)) {
                            throw new NoSuchFileException(path.toString());
                        }
                        counters$LongPathCounters = counters$LongPathCounters2;
                        counters$LongPathCounters2 = new Counters$LongPathCounters();
                        Objects.requireNonNull(path, "path");
                        long l = (linkOptionArray != null ? Files.exists(path, linkOptionArray) : Files.exists(path, new LinkOption[0])) && !Files.isSymbolicLink(path) ? Files.size(path) : 0L;
                        try {
                            if (Files.deleteIfExists(path)) {
                                Counters$LongPathCounters counters$LongPathCounters3 = counters$LongPathCounters;
                                ++((Counters$LongCounter)counters$LongPathCounters3.fileCounter).value;
                                ((Counters$LongCounter)counters$LongPathCounters3.byteCounter).value += l;
                                return counters$LongPathCounters3;
                            }
                        }
                        catch (AccessDeniedException accessDeniedException) {}
                        DeleteOption[] deleteOptionArray = object;
                        object = path.getParent();
                        posixFileAttributes = null;
                        try {
                            if (!PathUtils.overrideReadOnly(deleteOptionArray)) break block13;
                            object2 = PosixFileAttributes.class;
                            if (object == null) break block14;
                            try {
                                object2 = Files.readAttributes((Path)object, object2, linkOptionArray);
                                break block15;
                            }
                            catch (IOException iOException) {
                            }
                            catch (UnsupportedOperationException unsupportedOperationException) {}
                        }
                        catch (Throwable throwable2) {
                            break block16;
                        }
                    }
                    object2 = null;
                }
                posixFileAttributes = (PosixFileAttributes)object2;
                PathUtils.setReadOnly(path, linkOptionArray);
            }
            boolean bl = linkOptionArray != null ? Files.exists(path, linkOptionArray) : Files.exists(path, new LinkOption[0]);
            long l = bl && !Files.isSymbolicLink(path) ? Files.size(path) : 0L;
            if (Files.deleteIfExists(path)) {
                Counters$LongPathCounters counters$LongPathCounters4 = counters$LongPathCounters;
                ++((Counters$LongCounter)counters$LongPathCounters4.fileCounter).value;
                ((Counters$LongCounter)counters$LongPathCounters4.byteCounter).value += l;
            }
            if (posixFileAttributes != null) {
                Files.setPosixFilePermissions((Path)object, posixFileAttributes.permissions());
            }
            return counters$LongPathCounters;
        }
        if (posixFileAttributes != null) {
            Files.setPosixFilePermissions((Path)object, posixFileAttributes.permissions());
        }
        throw throwable2;
    }

    public static void setReadOnly(Path iterable, LinkOption ... object) {
        HashSet<PosixFilePermission> hashSet;
        block9: {
            boolean bl = false;
            try {
                hashSet = Files.getFileAttributeView(iterable, DosFileAttributeView.class, object);
                if (hashSet == null) break block9;
            }
            catch (IOException iOException) {}
            hashSet.setReadOnly(bl);
            return;
        }
        Object[] objectArray = iterable == null ? null : iterable.getParent();
        Objects.requireNonNull(objectArray, "path");
        if (object != null ? Files.exists((Path)objectArray, object) : Files.exists((Path)objectArray, new LinkOption[0])) {
            block10: {
                try {
                    hashSet = Files.readAttributes((Path)objectArray, PosixFileAttributes.class, object);
                    break block10;
                }
                catch (IOException iOException) {
                }
                catch (UnsupportedOperationException unsupportedOperationException) {}
                hashSet = null;
            }
            if ((PosixFileAttributes)((Object)hashSet) != null) {
                HashSet hashSet2;
                iterable = Arrays.asList(PosixFilePermission.OWNER_WRITE, PosixFilePermission.OWNER_EXECUTE);
                object = Files.getPosixFilePermissions((Path)objectArray, object);
                hashSet = hashSet2;
                hashSet((Collection<PosixFilePermission>)object);
                hashSet.addAll((Collection<PosixFilePermission>)iterable);
                if (!hashSet2.equals(object)) {
                    Files.setPosixFilePermissions((Path)objectArray, hashSet);
                }
                return;
            }
        }
        object = Arrays.toString(object);
        Object[] objectArray2 = new Object[2];
        objectArray = objectArray2;
        objectArray2[0] = iterable;
        objectArray2[1] = object;
        throw new IOException(String.format("DOS or POSIX file operations not available for '%s' %s", objectArray));
    }
}

