/*
 * Decompiled with CFR 0.152.
 */
package org.jf.dexlib2.writer.util;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.google.common.collect.Lists;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import org.jf.dexlib2.base.BaseTryBlock;
import org.jf.dexlib2.iface.ExceptionHandler;
import org.jf.dexlib2.iface.TryBlock;
import org.jf.util.ExceptionWithContext;

public class TryListBuilder<EH extends ExceptionHandler> {
    private final MutableTryBlock<EH> listStart = new MutableTryBlock(0, 0);
    private final MutableTryBlock<EH> listEnd = new MutableTryBlock(0, 0);

    public TryListBuilder() {
        this.listStart.next = this.listEnd;
        this.listEnd.prev = this.listStart;
    }

    public static <EH extends ExceptionHandler> List<TryBlock<EH>> massageTryBlocks(List<? extends TryBlock<? extends EH>> tryBlocks) {
        TryListBuilder<ExceptionHandler> tlb = new TryListBuilder<ExceptionHandler>();
        for (TryBlock<EH> tryBlock : tryBlocks) {
            int startAddress = tryBlock.getStartCodeAddress();
            int endAddress = startAddress + tryBlock.getCodeUnitCount();
            for (ExceptionHandler exceptionHandler : tryBlock.getExceptionHandlers()) {
                tlb.addHandler(startAddress, endAddress, exceptionHandler);
            }
        }
        return tlb.getTryBlocks();
    }

    private TryBounds<EH> getBoundingRanges(int startAddress, int endAddress) {
        int currentEndAddress;
        int currentStartAddress;
        MutableTryBlock startBlock = null;
        MutableTryBlock tryBlock = this.listStart.next;
        while (tryBlock != this.listEnd) {
            currentStartAddress = tryBlock.startCodeAddress;
            currentEndAddress = tryBlock.endCodeAddress;
            if (startAddress == currentStartAddress) {
                startBlock = tryBlock;
                break;
            }
            if (startAddress > currentStartAddress && startAddress < currentEndAddress) {
                startBlock = tryBlock.split(startAddress);
                break;
            }
            if (startAddress < currentStartAddress) {
                if (endAddress <= currentStartAddress) {
                    startBlock = new MutableTryBlock(startAddress, endAddress);
                    tryBlock.prepend(startBlock);
                    return new TryBounds(startBlock, startBlock);
                }
                startBlock = new MutableTryBlock(startAddress, currentStartAddress);
                tryBlock.prepend(startBlock);
                break;
            }
            tryBlock = tryBlock.next;
        }
        if (startBlock == null) {
            startBlock = new MutableTryBlock(startAddress, endAddress);
            this.listEnd.prepend(startBlock);
            return new TryBounds(startBlock, startBlock);
        }
        tryBlock = startBlock;
        while (tryBlock != this.listEnd) {
            currentStartAddress = tryBlock.startCodeAddress;
            currentEndAddress = tryBlock.endCodeAddress;
            if (endAddress == currentEndAddress) {
                return new TryBounds(startBlock, tryBlock);
            }
            if (endAddress > currentStartAddress && endAddress < currentEndAddress) {
                tryBlock.split(endAddress);
                return new TryBounds(startBlock, tryBlock);
            }
            if (endAddress <= currentStartAddress) {
                MutableTryBlock endBlock = new MutableTryBlock(tryBlock.prev.endCodeAddress, endAddress);
                tryBlock.prepend(endBlock);
                return new TryBounds(startBlock, endBlock);
            }
            tryBlock = tryBlock.next;
        }
        MutableTryBlock endBlock = new MutableTryBlock(this.listEnd.prev.endCodeAddress, endAddress);
        this.listEnd.prepend(endBlock);
        return new TryBounds(startBlock, endBlock);
    }

    public void addHandler(int startAddress, int endAddress, EH handler) {
        TryBounds<EH> bounds = this.getBoundingRanges(startAddress, endAddress);
        MutableTryBlock<EH> startBlock = bounds.start;
        MutableTryBlock endBlock = bounds.end;
        int previousEnd = startAddress;
        MutableTryBlock<EH> tryBlock = startBlock;
        do {
            if (tryBlock.startCodeAddress > previousEnd) {
                MutableTryBlock newBlock = new MutableTryBlock(previousEnd, tryBlock.startCodeAddress);
                tryBlock.prepend(newBlock);
                tryBlock = newBlock;
            }
            tryBlock.addHandler(handler);
            previousEnd = tryBlock.endCodeAddress;
            tryBlock = tryBlock.next;
        } while (tryBlock.prev != endBlock);
    }

    public List<TryBlock<EH>> getTryBlocks() {
        return Lists.newArrayList(new Iterator<TryBlock<EH>>(){
            @Nullable
            private MutableTryBlock<EH> next;
            {
                this.next = TryListBuilder.this.listStart;
                this.next = this.readNextItem();
            }

            @Nullable
            protected MutableTryBlock<EH> readNextItem() {
                MutableTryBlock ret = this.next.next;
                if (ret == TryListBuilder.this.listEnd) {
                    return null;
                }
                while (ret.next != TryListBuilder.this.listEnd && ret.endCodeAddress == ret.next.startCodeAddress && ret.getExceptionHandlers().equals(ret.next.getExceptionHandlers())) {
                    ret.mergeNext();
                }
                return ret;
            }

            @Override
            public boolean hasNext() {
                return this.next != null;
            }

            @Override
            @NonNull
            public TryBlock<EH> next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                MutableTryBlock ret = this.next;
                this.next = this.readNextItem();
                MutableTryBlock mutableTryBlock = ret;
                if (mutableTryBlock == null) {
                    1.$$$reportNull$$$0(0);
                }
                return mutableTryBlock;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NonNull method %s.%s must not return null", "org/jf/dexlib2/writer/util/TryListBuilder$1", "next"));
            }
        });
    }

    private static class MutableTryBlock<EH extends ExceptionHandler>
    extends BaseTryBlock<EH> {
        public MutableTryBlock<EH> prev;
        public MutableTryBlock<EH> next;
        public int startCodeAddress;
        public int endCodeAddress;
        @NonNull
        public List<EH> exceptionHandlers;

        public MutableTryBlock(int startCodeAddress, int endCodeAddress) {
            this.prev = null;
            this.next = null;
            this.exceptionHandlers = Lists.newArrayList();
            this.startCodeAddress = startCodeAddress;
            this.endCodeAddress = endCodeAddress;
        }

        public MutableTryBlock(int startCodeAddress, int endCodeAddress, @NonNull List<EH> exceptionHandlers) {
            if (exceptionHandlers == null) {
                MutableTryBlock.$$$reportNull$$$0(0);
            }
            this.prev = null;
            this.next = null;
            this.exceptionHandlers = Lists.newArrayList();
            this.startCodeAddress = startCodeAddress;
            this.endCodeAddress = endCodeAddress;
            this.exceptionHandlers = Lists.newArrayList(exceptionHandlers);
        }

        @Override
        public int getStartCodeAddress() {
            return this.startCodeAddress;
        }

        @Override
        public int getCodeUnitCount() {
            return this.endCodeAddress - this.startCodeAddress;
        }

        @Override
        @NonNull
        public List<EH> getExceptionHandlers() {
            List<EH> list = this.exceptionHandlers;
            if (list == null) {
                MutableTryBlock.$$$reportNull$$$0(1);
            }
            return list;
        }

        @NonNull
        public MutableTryBlock<EH> split(int splitAddress) {
            MutableTryBlock<EH> newTryBlock = new MutableTryBlock<EH>(splitAddress, this.endCodeAddress, this.exceptionHandlers);
            this.endCodeAddress = splitAddress;
            this.append(newTryBlock);
            MutableTryBlock<EH> mutableTryBlock = newTryBlock;
            if (mutableTryBlock == null) {
                MutableTryBlock.$$$reportNull$$$0(2);
            }
            return mutableTryBlock;
        }

        public void delete() {
            this.next.prev = this.prev;
            this.prev.next = this.next;
        }

        public void mergeNext() {
            this.endCodeAddress = this.next.endCodeAddress;
            this.next.delete();
        }

        public void append(@NonNull MutableTryBlock<EH> tryBlock) {
            if (tryBlock == null) {
                MutableTryBlock.$$$reportNull$$$0(3);
            }
            this.next.prev = tryBlock;
            tryBlock.next = this.next;
            tryBlock.prev = this;
            this.next = tryBlock;
        }

        public void prepend(@NonNull MutableTryBlock<EH> tryBlock) {
            if (tryBlock == null) {
                MutableTryBlock.$$$reportNull$$$0(4);
            }
            this.prev.next = tryBlock;
            tryBlock.prev = this.prev;
            tryBlock.next = this;
            this.prev = tryBlock;
        }

        public void addHandler(@NonNull EH handler) {
            if (handler == null) {
                MutableTryBlock.$$$reportNull$$$0(5);
            }
            for (ExceptionHandler existingHandler : this.exceptionHandlers) {
                String existingType = existingHandler.getExceptionType();
                String newType = handler.getExceptionType();
                if (existingType == null) {
                    if (newType != null) continue;
                    if (existingHandler.getHandlerCodeAddress() != handler.getHandlerCodeAddress()) {
                        throw new InvalidTryException("Multiple overlapping catch all handlers with different handlers", new Object[0]);
                    }
                    return;
                }
                if (!existingType.equals(newType)) continue;
                return;
            }
            this.exceptionHandlers.add(handler);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NonNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 2: {
                    string = "@NonNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "exceptionHandlers";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jf/dexlib2/writer/util/TryListBuilder$MutableTryBlock";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "tryBlock";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "handler";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jf/dexlib2/writer/util/TryListBuilder$MutableTryBlock";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getExceptionHandlers";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "split";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: {
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "append";
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "prepend";
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "addHandler";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static class InvalidTryException
    extends ExceptionWithContext {
        public InvalidTryException(Throwable cause) {
            super(cause);
        }

        public InvalidTryException(Throwable cause, String message, Object ... formatArgs) {
            super(cause, message, formatArgs);
        }

        public InvalidTryException(String message, Object ... formatArgs) {
            super(message, formatArgs);
        }
    }

    private static class TryBounds<EH extends ExceptionHandler> {
        @NonNull
        public final MutableTryBlock<EH> start;
        @NonNull
        public final MutableTryBlock<EH> end;

        public TryBounds(@NonNull MutableTryBlock<EH> start, @NonNull MutableTryBlock<EH> end) {
            if (start == null) {
                TryBounds.$$$reportNull$$$0(0);
            }
            if (end == null) {
                TryBounds.$$$reportNull$$$0(1);
            }
            this.start = start;
            this.end = end;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "start";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "end";
                    break;
                }
            }
            objectArray[1] = "org/jf/dexlib2/writer/util/TryListBuilder$TryBounds";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NonNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

