/*
 * Decompiled with CFR 0.152.
 */
package org.jf.dexlib2.writer.io;

import android.support.annotation.NonNull;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import org.jf.dexlib2.writer.io.DexDataStore;

public class MemoryDataStore
implements DexDataStore {
    private byte[] buf;
    private int length = 0;

    public MemoryDataStore() {
        this(0x100000);
    }

    public MemoryDataStore(int initialCapacity) {
        this.buf = new byte[initialCapacity];
    }

    public byte[] getBufferData() {
        return this.buf;
    }

    public int getSize() {
        return this.length;
    }

    @Override
    @NonNull
    public OutputStream outputAt(final int offset) {
        OutputStream outputStream = new OutputStream(){
            private int position;
            {
                this.position = offset;
            }

            @Override
            public void write(int b) throws IOException {
                MemoryDataStore.this.growBufferIfNeeded(this.position);
                ((MemoryDataStore)MemoryDataStore.this).buf[this.position++] = (byte)b;
                if (this.position > MemoryDataStore.this.length) {
                    MemoryDataStore.this.length = this.position;
                }
            }

            @Override
            public void write(@NonNull byte[] b) throws IOException {
                if (b == null) {
                    1.$$$reportNull$$$0(0);
                }
                MemoryDataStore.this.growBufferIfNeeded(this.position + b.length);
                System.arraycopy(b, 0, MemoryDataStore.this.buf, this.position, b.length);
                this.position += b.length;
                if (this.position > MemoryDataStore.this.length) {
                    MemoryDataStore.this.length = this.position;
                }
            }

            @Override
            public void write(@NonNull byte[] b, int off, int len) throws IOException {
                if (b == null) {
                    1.$$$reportNull$$$0(1);
                }
                MemoryDataStore.this.growBufferIfNeeded(this.position + len);
                System.arraycopy(b, off, MemoryDataStore.this.buf, this.position, len);
                this.position += len;
                if (this.position > MemoryDataStore.this.length) {
                    MemoryDataStore.this.length = this.position;
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NonNull parameter '%s' of %s.%s must not be null", "b", "org/jf/dexlib2/writer/io/MemoryDataStore$1", "write"));
            }
        };
        if (outputStream == null) {
            MemoryDataStore.$$$reportNull$$$0(0);
        }
        return outputStream;
    }

    private void growBufferIfNeeded(int index) {
        if (index < this.buf.length) {
            return;
        }
        this.buf = Arrays.copyOf(this.buf, (int)((double)(index + 1) * 1.2));
    }

    @Override
    @NonNull
    public InputStream readAt(final int offset) {
        InputStream inputStream = new InputStream(){
            private int position;
            {
                this.position = offset;
            }

            @Override
            public int read() throws IOException {
                if (this.position >= MemoryDataStore.this.length) {
                    return -1;
                }
                return MemoryDataStore.this.buf[this.position++];
            }

            @Override
            public int read(@NonNull byte[] b) throws IOException {
                int readLength;
                if (b == null) {
                    2.$$$reportNull$$$0(0);
                }
                if ((readLength = Math.min(b.length, MemoryDataStore.this.length - this.position)) <= 0) {
                    if (this.position >= MemoryDataStore.this.length) {
                        return -1;
                    }
                    return 0;
                }
                System.arraycopy(MemoryDataStore.this.buf, this.position, b, 0, readLength);
                this.position += readLength;
                return readLength;
            }

            @Override
            public int read(@NonNull byte[] b, int off, int len) throws IOException {
                int readLength;
                if (b == null) {
                    2.$$$reportNull$$$0(1);
                }
                if ((readLength = Math.min(len, MemoryDataStore.this.length - this.position)) <= 0) {
                    if (this.position >= MemoryDataStore.this.length) {
                        return -1;
                    }
                    return 0;
                }
                System.arraycopy(MemoryDataStore.this.buf, this.position, b, 0, readLength);
                this.position += readLength;
                return readLength;
            }

            @Override
            public long skip(long n) throws IOException {
                int skipLength = (int)Math.min(n, (long)(MemoryDataStore.this.length - this.position));
                this.position += skipLength;
                return skipLength;
            }

            @Override
            public int available() throws IOException {
                return MemoryDataStore.this.length - this.position;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NonNull parameter '%s' of %s.%s must not be null", "b", "org/jf/dexlib2/writer/io/MemoryDataStore$2", "read"));
            }
        };
        if (inputStream == null) {
            MemoryDataStore.$$$reportNull$$$0(1);
        }
        return inputStream;
    }

    @Override
    public void close() throws IOException {
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "org/jf/dexlib2/writer/io/MemoryDataStore";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "outputAt";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "readAt";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NonNull method %s.%s must not return null", objectArray));
    }
}

