/*
 * Decompiled with CFR 0.152.
 */
package org.jf.dexlib2.writer.builder;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import com.google.common.collect.Ordering;
import java.io.IOException;
import java.util.AbstractCollection;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.concurrent.ConcurrentMap;
import org.jf.dexlib2.builder.MutableMethodImplementation;
import org.jf.dexlib2.iface.ExceptionHandler;
import org.jf.dexlib2.iface.Field;
import org.jf.dexlib2.iface.MethodImplementation;
import org.jf.dexlib2.iface.TryBlock;
import org.jf.dexlib2.iface.debug.DebugItem;
import org.jf.dexlib2.iface.debug.EndLocal;
import org.jf.dexlib2.iface.debug.LineNumber;
import org.jf.dexlib2.iface.debug.RestartLocal;
import org.jf.dexlib2.iface.debug.SetSourceFile;
import org.jf.dexlib2.iface.debug.StartLocal;
import org.jf.dexlib2.iface.instruction.Instruction;
import org.jf.dexlib2.iface.reference.StringReference;
import org.jf.dexlib2.iface.reference.TypeReference;
import org.jf.dexlib2.iface.value.EncodedValue;
import org.jf.dexlib2.util.EncodedValueUtils;
import org.jf.dexlib2.writer.ClassSection;
import org.jf.dexlib2.writer.DebugWriter;
import org.jf.dexlib2.writer.builder.BaseBuilderPool;
import org.jf.dexlib2.writer.builder.BuilderAnnotationSet;
import org.jf.dexlib2.writer.builder.BuilderClassDef;
import org.jf.dexlib2.writer.builder.BuilderEncodedValues;
import org.jf.dexlib2.writer.builder.BuilderField;
import org.jf.dexlib2.writer.builder.BuilderMapEntryCollection;
import org.jf.dexlib2.writer.builder.BuilderMethod;
import org.jf.dexlib2.writer.builder.BuilderMethodParameter;
import org.jf.dexlib2.writer.builder.BuilderStringReference;
import org.jf.dexlib2.writer.builder.BuilderTypeList;
import org.jf.dexlib2.writer.builder.BuilderTypeReference;
import org.jf.dexlib2.writer.builder.DexBuilder;
import org.jf.util.AbstractForwardSequentialList;
import org.jf.util.CollectionUtils;
import org.jf.util.ExceptionWithContext;

public class BuilderClassPool
extends BaseBuilderPool
implements ClassSection<BuilderStringReference, BuilderTypeReference, BuilderTypeList, BuilderClassDef, BuilderField, BuilderMethod, BuilderAnnotationSet, BuilderEncodedValues.BuilderEncodedValue> {
    @NonNull
    private final ConcurrentMap<String, BuilderClassDef> internedItems;
    private ImmutableList<BuilderClassDef> sortedClasses;
    private static final Predicate<Field> HAS_INITIALIZER = new Predicate<Field>(){

        @Override
        public boolean apply(Field input) {
            EncodedValue encodedValue = input.getInitialValue();
            return encodedValue != null && !EncodedValueUtils.isDefaultValue(encodedValue);
        }
    };
    private static final Function<BuilderField, BuilderEncodedValues.BuilderEncodedValue> GET_INITIAL_VALUE = new Function<BuilderField, BuilderEncodedValues.BuilderEncodedValue>(){

        @Override
        public BuilderEncodedValues.BuilderEncodedValue apply(BuilderField input) {
            BuilderEncodedValues.BuilderEncodedValue initialValue = input.getInitialValue();
            if (initialValue == null) {
                return BuilderEncodedValues.defaultValueForType(input.getType());
            }
            return initialValue;
        }
    };
    private static final Predicate<BuilderMethodParameter> HAS_PARAMETER_ANNOTATIONS = new Predicate<BuilderMethodParameter>(){

        @Override
        public boolean apply(BuilderMethodParameter input) {
            return input.getAnnotations().size() > 0;
        }
    };
    private static final Function<BuilderMethodParameter, BuilderAnnotationSet> PARAMETER_ANNOTATIONS = new Function<BuilderMethodParameter, BuilderAnnotationSet>(){

        @Override
        public BuilderAnnotationSet apply(BuilderMethodParameter input) {
            return input.getAnnotations();
        }
    };

    public BuilderClassPool(@NonNull DexBuilder dexBuilder) {
        if (dexBuilder == null) {
            BuilderClassPool.$$$reportNull$$$0(0);
        }
        super(dexBuilder);
        this.internedItems = Maps.newConcurrentMap();
        this.sortedClasses = null;
    }

    @NonNull
    BuilderClassDef internClass(@NonNull BuilderClassDef classDef) {
        BuilderClassDef prev;
        if (classDef == null) {
            BuilderClassPool.$$$reportNull$$$0(1);
        }
        if ((prev = this.internedItems.put(classDef.getType(), classDef)) != null) {
            throw new ExceptionWithContext("Class %s has already been interned", classDef.getType());
        }
        BuilderClassDef builderClassDef = classDef;
        if (builderClassDef == null) {
            BuilderClassPool.$$$reportNull$$$0(2);
        }
        return builderClassDef;
    }

    @Override
    @NonNull
    public Collection<? extends BuilderClassDef> getSortedClasses() {
        if (this.sortedClasses == null) {
            this.sortedClasses = Ordering.natural().immutableSortedCopy(this.internedItems.values());
        }
        ImmutableList<BuilderClassDef> immutableList = this.sortedClasses;
        if (immutableList == null) {
            BuilderClassPool.$$$reportNull$$$0(3);
        }
        return immutableList;
    }

    @Override
    @Nullable
    public Map.Entry<? extends BuilderClassDef, Integer> getClassEntryByType(@Nullable BuilderTypeReference type) {
        if (type == null) {
            return null;
        }
        final BuilderClassDef classDef = (BuilderClassDef)this.internedItems.get(type.getType());
        if (classDef == null) {
            return null;
        }
        return new Map.Entry<BuilderClassDef, Integer>(){

            @Override
            public BuilderClassDef getKey() {
                return classDef;
            }

            @Override
            public Integer getValue() {
                return classDef.classDefIndex;
            }

            @Override
            public Integer setValue(Integer value) {
                classDef.classDefIndex = value;
                return classDef.classDefIndex;
            }
        };
    }

    @Override
    @NonNull
    public BuilderTypeReference getType(@NonNull BuilderClassDef builderClassDef) {
        if (builderClassDef == null) {
            BuilderClassPool.$$$reportNull$$$0(4);
        }
        BuilderTypeReference builderTypeReference = builderClassDef.type;
        if (builderTypeReference == null) {
            BuilderClassPool.$$$reportNull$$$0(5);
        }
        return builderTypeReference;
    }

    @Override
    public int getAccessFlags(@NonNull BuilderClassDef builderClassDef) {
        if (builderClassDef == null) {
            BuilderClassPool.$$$reportNull$$$0(6);
        }
        return builderClassDef.accessFlags;
    }

    @Override
    @Nullable
    public BuilderTypeReference getSuperclass(@NonNull BuilderClassDef builderClassDef) {
        if (builderClassDef == null) {
            BuilderClassPool.$$$reportNull$$$0(7);
        }
        return builderClassDef.superclass;
    }

    @Override
    @Nullable
    public BuilderTypeList getInterfaces(@NonNull BuilderClassDef builderClassDef) {
        if (builderClassDef == null) {
            BuilderClassPool.$$$reportNull$$$0(8);
        }
        return builderClassDef.interfaces;
    }

    @Override
    @Nullable
    public BuilderStringReference getSourceFile(@NonNull BuilderClassDef builderClassDef) {
        if (builderClassDef == null) {
            BuilderClassPool.$$$reportNull$$$0(9);
        }
        return builderClassDef.sourceFile;
    }

    @Override
    @Nullable
    public Collection<? extends BuilderEncodedValues.BuilderEncodedValue> getStaticInitializers(@NonNull BuilderClassDef classDef) {
        Iterable sortedStaticFields;
        int lastIndex;
        if (classDef == null) {
            BuilderClassPool.$$$reportNull$$$0(10);
        }
        if ((lastIndex = CollectionUtils.lastIndexOf(sortedStaticFields = classDef.getStaticFields(), HAS_INITIALIZER)) > -1) {
            return new AbstractCollection<BuilderEncodedValues.BuilderEncodedValue>((SortedSet)sortedStaticFields, lastIndex){
                final /* synthetic */ SortedSet val$sortedStaticFields;
                final /* synthetic */ int val$lastIndex;
                {
                    this.val$sortedStaticFields = sortedSet;
                    this.val$lastIndex = n;
                }

                @Override
                @NonNull
                public Iterator<BuilderEncodedValues.BuilderEncodedValue> iterator() {
                    Iterator<BuilderEncodedValues.BuilderEncodedValue> iterator = FluentIterable.from(this.val$sortedStaticFields).limit(this.val$lastIndex + 1).transform(GET_INITIAL_VALUE).iterator();
                    if (iterator == null) {
                        4.$$$reportNull$$$0(0);
                    }
                    return iterator;
                }

                @Override
                public int size() {
                    return this.val$lastIndex + 1;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalStateException(String.format("@NonNull method %s.%s must not return null", "org/jf/dexlib2/writer/builder/BuilderClassPool$4", "iterator"));
                }
            };
        }
        return null;
    }

    @Override
    @NonNull
    public Collection<? extends BuilderField> getSortedStaticFields(@NonNull BuilderClassDef builderClassDef) {
        if (builderClassDef == null) {
            BuilderClassPool.$$$reportNull$$$0(11);
        }
        Iterable iterable = builderClassDef.getStaticFields();
        if (iterable == null) {
            BuilderClassPool.$$$reportNull$$$0(12);
        }
        return iterable;
    }

    @Override
    @NonNull
    public Collection<? extends BuilderField> getSortedInstanceFields(@NonNull BuilderClassDef builderClassDef) {
        if (builderClassDef == null) {
            BuilderClassPool.$$$reportNull$$$0(13);
        }
        Iterable iterable = builderClassDef.getInstanceFields();
        if (iterable == null) {
            BuilderClassPool.$$$reportNull$$$0(14);
        }
        return iterable;
    }

    @Override
    @NonNull
    public Collection<? extends BuilderField> getSortedFields(@NonNull BuilderClassDef builderClassDef) {
        if (builderClassDef == null) {
            BuilderClassPool.$$$reportNull$$$0(15);
        }
        Iterable iterable = builderClassDef.getFields();
        if (iterable == null) {
            BuilderClassPool.$$$reportNull$$$0(16);
        }
        return iterable;
    }

    @Override
    @NonNull
    public Collection<? extends BuilderMethod> getSortedDirectMethods(@NonNull BuilderClassDef builderClassDef) {
        if (builderClassDef == null) {
            BuilderClassPool.$$$reportNull$$$0(17);
        }
        Iterable iterable = builderClassDef.getDirectMethods();
        if (iterable == null) {
            BuilderClassPool.$$$reportNull$$$0(18);
        }
        return iterable;
    }

    @Override
    @NonNull
    public Collection<? extends BuilderMethod> getSortedVirtualMethods(@NonNull BuilderClassDef builderClassDef) {
        if (builderClassDef == null) {
            BuilderClassPool.$$$reportNull$$$0(19);
        }
        Iterable iterable = builderClassDef.getVirtualMethods();
        if (iterable == null) {
            BuilderClassPool.$$$reportNull$$$0(20);
        }
        return iterable;
    }

    @Override
    @NonNull
    public Collection<? extends BuilderMethod> getSortedMethods(@NonNull BuilderClassDef builderClassDef) {
        if (builderClassDef == null) {
            BuilderClassPool.$$$reportNull$$$0(21);
        }
        Iterable iterable = builderClassDef.getMethods();
        if (iterable == null) {
            BuilderClassPool.$$$reportNull$$$0(22);
        }
        return iterable;
    }

    @Override
    public int getFieldAccessFlags(@NonNull BuilderField builderField) {
        if (builderField == null) {
            BuilderClassPool.$$$reportNull$$$0(23);
        }
        return builderField.accessFlags;
    }

    @Override
    public int getMethodAccessFlags(@NonNull BuilderMethod builderMethod) {
        if (builderMethod == null) {
            BuilderClassPool.$$$reportNull$$$0(24);
        }
        return builderMethod.accessFlags;
    }

    @Override
    @Nullable
    public BuilderAnnotationSet getClassAnnotations(@NonNull BuilderClassDef builderClassDef) {
        if (builderClassDef == null) {
            BuilderClassPool.$$$reportNull$$$0(25);
        }
        if (builderClassDef.annotations.isEmpty()) {
            return null;
        }
        return builderClassDef.annotations;
    }

    @Override
    @Nullable
    public BuilderAnnotationSet getFieldAnnotations(@NonNull BuilderField builderField) {
        if (builderField == null) {
            BuilderClassPool.$$$reportNull$$$0(26);
        }
        if (builderField.annotations.isEmpty()) {
            return null;
        }
        return builderField.annotations;
    }

    @Override
    @Nullable
    public BuilderAnnotationSet getMethodAnnotations(@NonNull BuilderMethod builderMethod) {
        if (builderMethod == null) {
            BuilderClassPool.$$$reportNull$$$0(27);
        }
        if (builderMethod.annotations.isEmpty()) {
            return null;
        }
        return builderMethod.annotations;
    }

    @Override
    @Nullable
    public List<? extends BuilderAnnotationSet> getParameterAnnotations(@NonNull BuilderMethod method) {
        List<? extends BuilderMethodParameter> parameters;
        boolean hasParameterAnnotations;
        if (method == null) {
            BuilderClassPool.$$$reportNull$$$0(28);
        }
        if (hasParameterAnnotations = Iterables.any(parameters = method.getParameters(), HAS_PARAMETER_ANNOTATIONS)) {
            return new AbstractForwardSequentialList<BuilderAnnotationSet>(){

                @Override
                @NonNull
                public Iterator<BuilderAnnotationSet> iterator() {
                    Iterator<BuilderAnnotationSet> iterator = FluentIterable.from(parameters).transform(PARAMETER_ANNOTATIONS).iterator();
                    if (iterator == null) {
                        7.$$$reportNull$$$0(0);
                    }
                    return iterator;
                }

                @Override
                public int size() {
                    return parameters.size();
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalStateException(String.format("@NonNull method %s.%s must not return null", "org/jf/dexlib2/writer/builder/BuilderClassPool$7", "iterator"));
                }
            };
        }
        return null;
    }

    @Override
    @Nullable
    public Iterable<? extends DebugItem> getDebugItems(@NonNull BuilderMethod builderMethod) {
        MethodImplementation impl;
        if (builderMethod == null) {
            BuilderClassPool.$$$reportNull$$$0(29);
        }
        if ((impl = builderMethod.getImplementation()) == null) {
            return null;
        }
        return impl.getDebugItems();
    }

    @Override
    @Nullable
    public Iterable<? extends BuilderStringReference> getParameterNames(@NonNull BuilderMethod method) {
        if (method == null) {
            BuilderClassPool.$$$reportNull$$$0(30);
        }
        return Iterables.transform(method.getParameters(), new Function<BuilderMethodParameter, BuilderStringReference>(){

            @Override
            @Nullable
            public BuilderStringReference apply(BuilderMethodParameter input) {
                return input.name;
            }
        });
    }

    @Override
    public int getRegisterCount(@NonNull BuilderMethod builderMethod) {
        MethodImplementation impl;
        if (builderMethod == null) {
            BuilderClassPool.$$$reportNull$$$0(31);
        }
        if ((impl = builderMethod.getImplementation()) == null) {
            return 0;
        }
        return impl.getRegisterCount();
    }

    @Override
    @Nullable
    public Iterable<? extends Instruction> getInstructions(@NonNull BuilderMethod builderMethod) {
        MethodImplementation impl;
        if (builderMethod == null) {
            BuilderClassPool.$$$reportNull$$$0(32);
        }
        if ((impl = builderMethod.getImplementation()) == null) {
            return null;
        }
        return impl.getInstructions();
    }

    @Override
    @NonNull
    public List<? extends TryBlock<? extends ExceptionHandler>> getTryBlocks(@NonNull BuilderMethod builderMethod) {
        MethodImplementation impl;
        if (builderMethod == null) {
            BuilderClassPool.$$$reportNull$$$0(33);
        }
        if ((impl = builderMethod.getImplementation()) == null) {
            ImmutableList immutableList = ImmutableList.of();
            if (immutableList == null) {
                BuilderClassPool.$$$reportNull$$$0(34);
            }
            return immutableList;
        }
        List<? extends TryBlock<? extends ExceptionHandler>> list = impl.getTryBlocks();
        if (list == null) {
            BuilderClassPool.$$$reportNull$$$0(35);
        }
        return list;
    }

    @Override
    @Nullable
    public BuilderTypeReference getExceptionType(@NonNull ExceptionHandler handler) {
        if (handler == null) {
            BuilderClassPool.$$$reportNull$$$0(36);
        }
        return this.checkTypeReference(handler.getExceptionTypeReference());
    }

    @Override
    @NonNull
    public MutableMethodImplementation makeMutableMethodImplementation(@NonNull BuilderMethod builderMethod) {
        MethodImplementation impl;
        if (builderMethod == null) {
            BuilderClassPool.$$$reportNull$$$0(37);
        }
        if ((impl = builderMethod.getImplementation()) instanceof MutableMethodImplementation) {
            MutableMethodImplementation mutableMethodImplementation = (MutableMethodImplementation)impl;
            if (mutableMethodImplementation == null) {
                BuilderClassPool.$$$reportNull$$$0(38);
            }
            return mutableMethodImplementation;
        }
        MutableMethodImplementation mutableMethodImplementation = new MutableMethodImplementation(impl);
        if (mutableMethodImplementation == null) {
            BuilderClassPool.$$$reportNull$$$0(39);
        }
        return mutableMethodImplementation;
    }

    @Override
    public void setEncodedArrayOffset(@NonNull BuilderClassDef builderClassDef, int offset) {
        if (builderClassDef == null) {
            BuilderClassPool.$$$reportNull$$$0(40);
        }
        builderClassDef.encodedArrayOffset = offset;
    }

    @Override
    public int getEncodedArrayOffset(@NonNull BuilderClassDef builderClassDef) {
        if (builderClassDef == null) {
            BuilderClassPool.$$$reportNull$$$0(41);
        }
        return builderClassDef.encodedArrayOffset;
    }

    @Override
    public void setAnnotationDirectoryOffset(@NonNull BuilderClassDef builderClassDef, int offset) {
        if (builderClassDef == null) {
            BuilderClassPool.$$$reportNull$$$0(42);
        }
        builderClassDef.annotationDirectoryOffset = offset;
    }

    @Override
    public int getAnnotationDirectoryOffset(@NonNull BuilderClassDef builderClassDef) {
        if (builderClassDef == null) {
            BuilderClassPool.$$$reportNull$$$0(43);
        }
        return builderClassDef.annotationDirectoryOffset;
    }

    @Override
    public void setAnnotationSetRefListOffset(@NonNull BuilderMethod builderMethod, int offset) {
        if (builderMethod == null) {
            BuilderClassPool.$$$reportNull$$$0(44);
        }
        builderMethod.annotationSetRefListOffset = offset;
    }

    @Override
    public int getAnnotationSetRefListOffset(@NonNull BuilderMethod builderMethod) {
        if (builderMethod == null) {
            BuilderClassPool.$$$reportNull$$$0(45);
        }
        return builderMethod.annotationSetRefListOffset;
    }

    @Override
    public void setCodeItemOffset(@NonNull BuilderMethod builderMethod, int offset) {
        if (builderMethod == null) {
            BuilderClassPool.$$$reportNull$$$0(46);
        }
        builderMethod.codeItemOffset = offset;
    }

    @Override
    public int getCodeItemOffset(@NonNull BuilderMethod builderMethod) {
        if (builderMethod == null) {
            BuilderClassPool.$$$reportNull$$$0(47);
        }
        return builderMethod.codeItemOffset;
    }

    @Nullable
    private BuilderStringReference checkStringReference(@Nullable StringReference stringReference) {
        if (stringReference == null) {
            return null;
        }
        try {
            return (BuilderStringReference)stringReference;
        }
        catch (ClassCastException ex) {
            throw new IllegalStateException("Only StringReference instances returned by DexBuilder.internStringReference or DexBuilder.internNullableStringReference may be used.");
        }
    }

    @Nullable
    private BuilderTypeReference checkTypeReference(@Nullable TypeReference typeReference) {
        if (typeReference == null) {
            return null;
        }
        try {
            return (BuilderTypeReference)typeReference;
        }
        catch (ClassCastException ex) {
            throw new IllegalStateException("Only TypeReference instances returned by DexBuilder.internTypeReference or DexBuilder.internNullableTypeReference may be used.");
        }
    }

    @Override
    public void writeDebugItem(@NonNull DebugWriter<BuilderStringReference, BuilderTypeReference> writer, DebugItem debugItem) throws IOException {
        if (writer == null) {
            BuilderClassPool.$$$reportNull$$$0(48);
        }
        switch (debugItem.getDebugItemType()) {
            case 3: {
                StartLocal startLocal = (StartLocal)debugItem;
                writer.writeStartLocal(startLocal.getCodeAddress(), startLocal.getRegister(), this.checkStringReference(startLocal.getNameReference()), this.checkTypeReference(startLocal.getTypeReference()), this.checkStringReference(startLocal.getSignatureReference()));
                break;
            }
            case 5: {
                EndLocal endLocal = (EndLocal)debugItem;
                writer.writeEndLocal(endLocal.getCodeAddress(), endLocal.getRegister());
                break;
            }
            case 6: {
                RestartLocal restartLocal = (RestartLocal)debugItem;
                writer.writeRestartLocal(restartLocal.getCodeAddress(), restartLocal.getRegister());
                break;
            }
            case 7: {
                writer.writePrologueEnd(debugItem.getCodeAddress());
                break;
            }
            case 8: {
                writer.writeEpilogueBegin(debugItem.getCodeAddress());
                break;
            }
            case 10: {
                LineNumber lineNumber = (LineNumber)debugItem;
                writer.writeLineNumber(lineNumber.getCodeAddress(), lineNumber.getLineNumber());
                break;
            }
            case 9: {
                SetSourceFile setSourceFile = (SetSourceFile)debugItem;
                writer.writeSetSourceFile(setSourceFile.getCodeAddress(), this.checkStringReference(setSourceFile.getSourceFileReference()));
                break;
            }
            default: {
                throw new ExceptionWithContext("Unexpected debug item type: %d", debugItem.getDebugItemType());
            }
        }
    }

    @Override
    public int getItemIndex(@NonNull BuilderClassDef builderClassDef) {
        if (builderClassDef == null) {
            BuilderClassPool.$$$reportNull$$$0(49);
        }
        return builderClassDef.classDefIndex;
    }

    @Override
    @NonNull
    public Collection<? extends Map.Entry<? extends BuilderClassDef, Integer>> getItems() {
        BuilderMapEntryCollection<BuilderClassDef> builderMapEntryCollection = new BuilderMapEntryCollection<BuilderClassDef>(this.internedItems.values()){

            @Override
            protected int getValue(@NonNull BuilderClassDef key) {
                if (key == null) {
                    9.$$$reportNull$$$0(0);
                }
                return key.classDefIndex;
            }

            @Override
            protected int setValue(@NonNull BuilderClassDef key, int value) {
                if (key == null) {
                    9.$$$reportNull$$$0(1);
                }
                int prev = key.classDefIndex;
                key.classDefIndex = value;
                return prev;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "key";
                objectArray2[1] = "org/jf/dexlib2/writer/builder/BuilderClassPool$9";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "getValue";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "setValue";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NonNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
        if (builderMapEntryCollection == null) {
            BuilderClassPool.$$$reportNull$$$0(50);
        }
        return builderMapEntryCollection;
    }

    @Override
    public int getItemCount() {
        return this.internedItems.size();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NonNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 12: 
            case 14: 
            case 16: 
            case 18: 
            case 20: 
            case 22: 
            case 34: 
            case 35: 
            case 38: 
            case 39: 
            case 50: {
                string = "@NonNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 12: 
            case 14: 
            case 16: 
            case 18: 
            case 20: 
            case 22: 
            case 34: 
            case 35: 
            case 38: 
            case 39: 
            case 50: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dexBuilder";
                break;
            }
            case 1: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classDef";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 12: 
            case 14: 
            case 16: 
            case 18: 
            case 20: 
            case 22: 
            case 34: 
            case 35: 
            case 38: 
            case 39: 
            case 50: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jf/dexlib2/writer/builder/BuilderClassPool";
                break;
            }
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 13: 
            case 15: 
            case 17: 
            case 19: 
            case 21: 
            case 25: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 49: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builderClassDef";
                break;
            }
            case 23: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builderField";
                break;
            }
            case 24: 
            case 27: 
            case 29: 
            case 31: 
            case 32: 
            case 33: 
            case 37: 
            case 44: 
            case 45: 
            case 46: 
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builderMethod";
                break;
            }
            case 28: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "handler";
                break;
            }
            case 48: {
                objectArray2 = objectArray3;
                objectArray3[0] = "writer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jf/dexlib2/writer/builder/BuilderClassPool";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "internClass";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getSortedClasses";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getType";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getSortedStaticFields";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getSortedInstanceFields";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getSortedFields";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getSortedDirectMethods";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getSortedVirtualMethods";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "getSortedMethods";
                break;
            }
            case 34: 
            case 35: {
                objectArray = objectArray2;
                objectArray2[1] = "getTryBlocks";
                break;
            }
            case 38: 
            case 39: {
                objectArray = objectArray2;
                objectArray2[1] = "makeMutableMethodImplementation";
                break;
            }
            case 50: {
                objectArray = objectArray2;
                objectArray2[1] = "getItems";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "internClass";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 12: 
            case 14: 
            case 16: 
            case 18: 
            case 20: 
            case 22: 
            case 34: 
            case 35: 
            case 38: 
            case 39: 
            case 50: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getType";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getAccessFlags";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getSuperclass";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getInterfaces";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getSourceFile";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getStaticInitializers";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getSortedStaticFields";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getSortedInstanceFields";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getSortedFields";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getSortedDirectMethods";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "getSortedVirtualMethods";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "getSortedMethods";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "getFieldAccessFlags";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "getMethodAccessFlags";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "getClassAnnotations";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "getFieldAnnotations";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "getMethodAnnotations";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "getParameterAnnotations";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "getDebugItems";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "getParameterNames";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "getRegisterCount";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "getInstructions";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "getTryBlocks";
                break;
            }
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "getExceptionType";
                break;
            }
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "makeMutableMethodImplementation";
                break;
            }
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "setEncodedArrayOffset";
                break;
            }
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "getEncodedArrayOffset";
                break;
            }
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "setAnnotationDirectoryOffset";
                break;
            }
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "getAnnotationDirectoryOffset";
                break;
            }
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "setAnnotationSetRefListOffset";
                break;
            }
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "getAnnotationSetRefListOffset";
                break;
            }
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "setCodeItemOffset";
                break;
            }
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "getCodeItemOffset";
                break;
            }
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "writeDebugItem";
                break;
            }
            case 49: {
                objectArray = objectArray;
                objectArray[2] = "getItemIndex";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 12: 
            case 14: 
            case 16: 
            case 18: 
            case 20: 
            case 22: 
            case 34: 
            case 35: 
            case 38: 
            case 39: 
            case 50: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

