/*
 * Decompiled with CFR 0.152.
 */
package org.jf.dexlib2.writer.builder;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.google.common.base.Functions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSortedSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import com.google.common.collect.Ordering;
import com.google.common.collect.UnmodifiableIterator;
import java.util.AbstractCollection;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.SortedSet;
import org.jf.dexlib2.base.reference.BaseTypeReference;
import org.jf.dexlib2.iface.ClassDef;
import org.jf.dexlib2.util.FieldUtil;
import org.jf.dexlib2.util.MethodUtil;
import org.jf.dexlib2.writer.builder.BuilderAnnotationSet;
import org.jf.dexlib2.writer.builder.BuilderField;
import org.jf.dexlib2.writer.builder.BuilderMethod;
import org.jf.dexlib2.writer.builder.BuilderStringReference;
import org.jf.dexlib2.writer.builder.BuilderTypeList;
import org.jf.dexlib2.writer.builder.BuilderTypeReference;

public class BuilderClassDef
extends BaseTypeReference
implements ClassDef {
    @NonNull
    final BuilderTypeReference type;
    final int accessFlags;
    @Nullable
    final BuilderTypeReference superclass;
    @NonNull
    final BuilderTypeList interfaces;
    @Nullable
    final BuilderStringReference sourceFile;
    @NonNull
    final BuilderAnnotationSet annotations;
    @NonNull
    final SortedSet<BuilderField> staticFields;
    @NonNull
    final SortedSet<BuilderField> instanceFields;
    @NonNull
    final SortedSet<BuilderMethod> directMethods;
    @NonNull
    final SortedSet<BuilderMethod> virtualMethods;
    int classDefIndex;
    int encodedArrayOffset;
    int annotationDirectoryOffset;

    BuilderClassDef(@NonNull BuilderTypeReference type, int accessFlags, @Nullable BuilderTypeReference superclass, @NonNull BuilderTypeList interfaces, @Nullable BuilderStringReference sourceFile, @NonNull BuilderAnnotationSet annotations, @Nullable Iterable<? extends BuilderField> fields, @Nullable Iterable<? extends BuilderMethod> methods) {
        if (type == null) {
            BuilderClassDef.$$$reportNull$$$0(0);
        }
        if (interfaces == null) {
            BuilderClassDef.$$$reportNull$$$0(1);
        }
        if (annotations == null) {
            BuilderClassDef.$$$reportNull$$$0(2);
        }
        this.classDefIndex = -1;
        this.encodedArrayOffset = 0;
        this.annotationDirectoryOffset = 0;
        if (fields == null) {
            fields = ImmutableList.of();
        }
        if (methods == null) {
            methods = ImmutableList.of();
        }
        this.type = type;
        this.accessFlags = accessFlags;
        this.superclass = superclass;
        this.interfaces = interfaces;
        this.sourceFile = sourceFile;
        this.annotations = annotations;
        this.staticFields = ImmutableSortedSet.copyOf(Iterables.filter(fields, FieldUtil.FIELD_IS_STATIC));
        this.instanceFields = ImmutableSortedSet.copyOf(Iterables.filter(fields, FieldUtil.FIELD_IS_INSTANCE));
        this.directMethods = ImmutableSortedSet.copyOf(Iterables.filter(methods, MethodUtil.METHOD_IS_DIRECT));
        this.virtualMethods = ImmutableSortedSet.copyOf(Iterables.filter(methods, MethodUtil.METHOD_IS_VIRTUAL));
    }

    @Override
    @NonNull
    public String getType() {
        String string = this.type.getType();
        if (string == null) {
            BuilderClassDef.$$$reportNull$$$0(3);
        }
        return string;
    }

    @Override
    public int getAccessFlags() {
        return this.accessFlags;
    }

    @Override
    @Nullable
    public String getSuperclass() {
        return this.superclass == null ? null : this.superclass.getType();
    }

    @Override
    @Nullable
    public String getSourceFile() {
        return this.sourceFile == null ? null : this.sourceFile.getString();
    }

    @NonNull
    public BuilderAnnotationSet getAnnotations() {
        BuilderAnnotationSet builderAnnotationSet = this.annotations;
        if (builderAnnotationSet == null) {
            BuilderClassDef.$$$reportNull$$$0(4);
        }
        return builderAnnotationSet;
    }

    @NonNull
    public SortedSet<BuilderField> getStaticFields() {
        SortedSet<BuilderField> sortedSet = this.staticFields;
        if (sortedSet == null) {
            BuilderClassDef.$$$reportNull$$$0(5);
        }
        return sortedSet;
    }

    @NonNull
    public SortedSet<BuilderField> getInstanceFields() {
        SortedSet<BuilderField> sortedSet = this.instanceFields;
        if (sortedSet == null) {
            BuilderClassDef.$$$reportNull$$$0(6);
        }
        return sortedSet;
    }

    @NonNull
    public SortedSet<BuilderMethod> getDirectMethods() {
        SortedSet<BuilderMethod> sortedSet = this.directMethods;
        if (sortedSet == null) {
            BuilderClassDef.$$$reportNull$$$0(7);
        }
        return sortedSet;
    }

    @NonNull
    public SortedSet<BuilderMethod> getVirtualMethods() {
        SortedSet<BuilderMethod> sortedSet = this.virtualMethods;
        if (sortedSet == null) {
            BuilderClassDef.$$$reportNull$$$0(8);
        }
        return sortedSet;
    }

    @Override
    @NonNull
    public List<String> getInterfaces() {
        List<String> list = Lists.transform(this.interfaces, Functions.toStringFunction());
        if (list == null) {
            BuilderClassDef.$$$reportNull$$$0(9);
        }
        return list;
    }

    @NonNull
    public Collection<BuilderField> getFields() {
        AbstractCollection<BuilderField> abstractCollection = new AbstractCollection<BuilderField>(){

            @Override
            @NonNull
            public Iterator<BuilderField> iterator() {
                UnmodifiableIterator<BuilderField> unmodifiableIterator = Iterators.mergeSorted(ImmutableList.of(BuilderClassDef.this.staticFields.iterator(), BuilderClassDef.this.instanceFields.iterator()), Ordering.natural());
                if (unmodifiableIterator == null) {
                    1.$$$reportNull$$$0(0);
                }
                return unmodifiableIterator;
            }

            @Override
            public int size() {
                return BuilderClassDef.this.staticFields.size() + BuilderClassDef.this.instanceFields.size();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NonNull method %s.%s must not return null", "org/jf/dexlib2/writer/builder/BuilderClassDef$1", "iterator"));
            }
        };
        if (abstractCollection == null) {
            BuilderClassDef.$$$reportNull$$$0(10);
        }
        return abstractCollection;
    }

    @NonNull
    public Collection<BuilderMethod> getMethods() {
        AbstractCollection<BuilderMethod> abstractCollection = new AbstractCollection<BuilderMethod>(){

            @Override
            @NonNull
            public Iterator<BuilderMethod> iterator() {
                UnmodifiableIterator<BuilderMethod> unmodifiableIterator = Iterators.mergeSorted(ImmutableList.of(BuilderClassDef.this.directMethods.iterator(), BuilderClassDef.this.virtualMethods.iterator()), Ordering.natural());
                if (unmodifiableIterator == null) {
                    2.$$$reportNull$$$0(0);
                }
                return unmodifiableIterator;
            }

            @Override
            public int size() {
                return BuilderClassDef.this.directMethods.size() + BuilderClassDef.this.virtualMethods.size();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NonNull method %s.%s must not return null", "org/jf/dexlib2/writer/builder/BuilderClassDef$2", "iterator"));
            }
        };
        if (abstractCollection == null) {
            BuilderClassDef.$$$reportNull$$$0(11);
        }
        return abstractCollection;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NonNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                string = "@NonNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "interfaces";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "annotations";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jf/dexlib2/writer/builder/BuilderClassDef";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jf/dexlib2/writer/builder/BuilderClassDef";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getType";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getAnnotations";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getStaticFields";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstanceFields";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getDirectMethods";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getVirtualMethods";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getInterfaces";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getFields";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getMethods";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

