/*
 * Decompiled with CFR 0.152.
 */
package org.jf.dexlib2.immutable.instruction;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.google.common.collect.ImmutableList;
import java.util.List;
import org.jf.dexlib2.Format;
import org.jf.dexlib2.Opcode;
import org.jf.dexlib2.iface.instruction.SwitchElement;
import org.jf.dexlib2.iface.instruction.formats.SparseSwitchPayload;
import org.jf.dexlib2.immutable.instruction.ImmutableInstruction;
import org.jf.dexlib2.immutable.instruction.ImmutableSwitchElement;
import org.jf.util.ImmutableUtils;

public class ImmutableSparseSwitchPayload
extends ImmutableInstruction
implements SparseSwitchPayload {
    public static final Opcode OPCODE = Opcode.SPARSE_SWITCH_PAYLOAD;
    @NonNull
    protected final ImmutableList<? extends ImmutableSwitchElement> switchElements;

    public ImmutableSparseSwitchPayload(@Nullable List<? extends SwitchElement> switchElements) {
        super(OPCODE);
        this.switchElements = ImmutableSwitchElement.immutableListOf(switchElements);
    }

    public ImmutableSparseSwitchPayload(@Nullable ImmutableList<? extends ImmutableSwitchElement> switchElements) {
        super(OPCODE);
        this.switchElements = ImmutableUtils.nullToEmptyList(switchElements);
    }

    @NonNull
    public static ImmutableSparseSwitchPayload of(SparseSwitchPayload instruction) {
        if (instruction instanceof ImmutableSparseSwitchPayload) {
            ImmutableSparseSwitchPayload immutableSparseSwitchPayload = (ImmutableSparseSwitchPayload)instruction;
            if (immutableSparseSwitchPayload == null) {
                ImmutableSparseSwitchPayload.$$$reportNull$$$0(0);
            }
            return immutableSparseSwitchPayload;
        }
        ImmutableSparseSwitchPayload immutableSparseSwitchPayload = new ImmutableSparseSwitchPayload(instruction.getSwitchElements());
        if (immutableSparseSwitchPayload == null) {
            ImmutableSparseSwitchPayload.$$$reportNull$$$0(1);
        }
        return immutableSparseSwitchPayload;
    }

    @Override
    @NonNull
    public List<? extends SwitchElement> getSwitchElements() {
        ImmutableList<? extends ImmutableSwitchElement> immutableList = this.switchElements;
        if (immutableList == null) {
            ImmutableSparseSwitchPayload.$$$reportNull$$$0(2);
        }
        return immutableList;
    }

    @Override
    public int getCodeUnits() {
        return 2 + this.switchElements.size() * 4;
    }

    @Override
    public Format getFormat() {
        return ImmutableSparseSwitchPayload.OPCODE.format;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "org/jf/dexlib2/immutable/instruction/ImmutableSparseSwitchPayload";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "of";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getSwitchElements";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NonNull method %s.%s must not return null", objectArray));
    }
}

