/*
 * Decompiled with CFR 0.152.
 */
package org.jf.dexlib2.dexbacked.reference;

import android.support.annotation.NonNull;
import com.google.common.collect.ImmutableList;
import java.util.List;
import org.jf.dexlib2.base.reference.BaseMethodReference;
import org.jf.dexlib2.dexbacked.DexBackedDexFile;
import org.jf.dexlib2.dexbacked.reference.DexBackedMethodProtoReference;
import org.jf.dexlib2.dexbacked.util.FixedSizeList;

public class DexBackedMethodReference
extends BaseMethodReference {
    @NonNull
    public final DexBackedDexFile dexFile;
    public final int methodIdItemOffset;
    private int protoIdItemOffset;

    public DexBackedMethodReference(@NonNull DexBackedDexFile dexFile, int methodIndex) {
        if (dexFile == null) {
            DexBackedMethodReference.$$$reportNull$$$0(0);
        }
        this.dexFile = dexFile;
        this.methodIdItemOffset = dexFile.getMethodIdItemOffset(methodIndex);
    }

    @Override
    @NonNull
    public String getDefiningClass() {
        String string = this.dexFile.getType(this.dexFile.readUshort(this.methodIdItemOffset + 0));
        if (string == null) {
            DexBackedMethodReference.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    @NonNull
    public String getName() {
        String string = this.dexFile.getString(this.dexFile.readSmallUint(this.methodIdItemOffset + 4));
        if (string == null) {
            DexBackedMethodReference.$$$reportNull$$$0(2);
        }
        return string;
    }

    @NonNull
    public List<String> getParameterTypes() {
        int protoIdItemOffset = this.getProtoIdItemOffset();
        int parametersOffset = this.dexFile.readSmallUint(protoIdItemOffset + 8);
        if (parametersOffset > 0) {
            final int parameterCount = this.dexFile.readSmallUint(parametersOffset + 0);
            final int paramListStart = parametersOffset + 4;
            FixedSizeList<String> fixedSizeList = new FixedSizeList<String>(){

                @Override
                @NonNull
                public String readItem(int index) {
                    String string = DexBackedMethodReference.this.dexFile.getType(DexBackedMethodReference.this.dexFile.readUshort(paramListStart + 2 * index));
                    if (string == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    return string;
                }

                @Override
                public int size() {
                    return parameterCount;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalStateException(String.format("@NonNull method %s.%s must not return null", "org/jf/dexlib2/dexbacked/reference/DexBackedMethodReference$1", "readItem"));
                }
            };
            if (fixedSizeList == null) {
                DexBackedMethodReference.$$$reportNull$$$0(3);
            }
            return fixedSizeList;
        }
        ImmutableList<String> immutableList = ImmutableList.of();
        if (immutableList == null) {
            DexBackedMethodReference.$$$reportNull$$$0(4);
        }
        return immutableList;
    }

    @Override
    @NonNull
    public String getReturnType() {
        int protoIdItemOffset = this.getProtoIdItemOffset();
        String string = this.dexFile.getType(this.dexFile.readSmallUint(protoIdItemOffset + 4));
        if (string == null) {
            DexBackedMethodReference.$$$reportNull$$$0(5);
        }
        return string;
    }

    private int getProtoIdItemOffset() {
        if (this.protoIdItemOffset == 0) {
            this.protoIdItemOffset = this.dexFile.getProtoIdItemOffset(this.dexFile.readUshort(this.methodIdItemOffset + 2));
        }
        return this.protoIdItemOffset;
    }

    public int getSize() {
        int size = 8;
        DexBackedMethodProtoReference protoRef = new DexBackedMethodProtoReference(this.dexFile, this.dexFile.readUshort(this.methodIdItemOffset + 2));
        return size += protoRef.getSize();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NonNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                string = "@NonNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dexFile";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jf/dexlib2/dexbacked/reference/DexBackedMethodReference";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jf/dexlib2/dexbacked/reference/DexBackedMethodReference";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefiningClass";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getParameterTypes";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getReturnType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

