/*
 * Decompiled with CFR 0.152.
 */
package org.jf.dexlib2.dexbacked.instruction;

import android.support.annotation.NonNull;
import java.util.List;
import org.jf.dexlib2.Opcode;
import org.jf.dexlib2.dexbacked.DexBackedDexFile;
import org.jf.dexlib2.dexbacked.instruction.DexBackedInstruction;
import org.jf.dexlib2.dexbacked.util.FixedSizeList;
import org.jf.dexlib2.iface.instruction.formats.ArrayPayload;
import org.jf.util.ExceptionWithContext;

public class DexBackedArrayPayload
extends DexBackedInstruction
implements ArrayPayload {
    public static final Opcode OPCODE = Opcode.ARRAY_PAYLOAD;
    public final int elementWidth;
    public final int elementCount;
    private static final int ELEMENT_WIDTH_OFFSET = 2;
    private static final int ELEMENT_COUNT_OFFSET = 4;
    private static final int ELEMENTS_OFFSET = 8;

    public DexBackedArrayPayload(@NonNull DexBackedDexFile dexFile, int instructionStart) {
        if (dexFile == null) {
            DexBackedArrayPayload.$$$reportNull$$$0(0);
        }
        super(dexFile, OPCODE, instructionStart);
        this.elementWidth = dexFile.readUshort(instructionStart + 2);
        this.elementCount = dexFile.readSmallUint(instructionStart + 4);
        if ((long)this.elementWidth * (long)this.elementCount > Integer.MAX_VALUE) {
            throw new ExceptionWithContext("Invalid array-payload instruction: element width*count overflows", new Object[0]);
        }
    }

    @Override
    public int getElementWidth() {
        return this.elementWidth;
    }

    @Override
    @NonNull
    public List<Number> getArrayElements() {
        final int elementsStart = this.instructionStart + 8;
        switch (this.elementWidth) {
            abstract class ReturnedList
            extends FixedSizeList<Number> {
                ReturnedList() {
                }

                @Override
                public int size() {
                    return DexBackedArrayPayload.this.elementCount;
                }
            }
            case 1: {
                ReturnedList returnedList = new ReturnedList(){
                    {
                    }

                    @Override
                    @NonNull
                    public Number readItem(int index) {
                        Integer n = DexBackedArrayPayload.this.dexFile.readByte(elementsStart + index);
                        if (n == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        return n;
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        throw new IllegalStateException(String.format("@NonNull method %s.%s must not return null", "org/jf/dexlib2/dexbacked/instruction/DexBackedArrayPayload$1", "readItem"));
                    }
                };
                if (returnedList == null) {
                    DexBackedArrayPayload.$$$reportNull$$$0(1);
                }
                return returnedList;
            }
            case 2: {
                ReturnedList returnedList = new ReturnedList(){
                    {
                    }

                    @Override
                    @NonNull
                    public Number readItem(int index) {
                        Integer n = DexBackedArrayPayload.this.dexFile.readShort(elementsStart + index * 2);
                        if (n == null) {
                            2.$$$reportNull$$$0(0);
                        }
                        return n;
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        throw new IllegalStateException(String.format("@NonNull method %s.%s must not return null", "org/jf/dexlib2/dexbacked/instruction/DexBackedArrayPayload$2", "readItem"));
                    }
                };
                if (returnedList == null) {
                    DexBackedArrayPayload.$$$reportNull$$$0(2);
                }
                return returnedList;
            }
            case 4: {
                ReturnedList returnedList = new ReturnedList(){
                    {
                    }

                    @Override
                    @NonNull
                    public Number readItem(int index) {
                        Integer n = DexBackedArrayPayload.this.dexFile.readInt(elementsStart + index * 4);
                        if (n == null) {
                            3.$$$reportNull$$$0(0);
                        }
                        return n;
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        throw new IllegalStateException(String.format("@NonNull method %s.%s must not return null", "org/jf/dexlib2/dexbacked/instruction/DexBackedArrayPayload$3", "readItem"));
                    }
                };
                if (returnedList == null) {
                    DexBackedArrayPayload.$$$reportNull$$$0(3);
                }
                return returnedList;
            }
            case 8: {
                ReturnedList returnedList = new ReturnedList(){
                    {
                    }

                    @Override
                    @NonNull
                    public Number readItem(int index) {
                        Long l = DexBackedArrayPayload.this.dexFile.readLong(elementsStart + index * 8);
                        if (l == null) {
                            4.$$$reportNull$$$0(0);
                        }
                        return l;
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        throw new IllegalStateException(String.format("@NonNull method %s.%s must not return null", "org/jf/dexlib2/dexbacked/instruction/DexBackedArrayPayload$4", "readItem"));
                    }
                };
                if (returnedList == null) {
                    DexBackedArrayPayload.$$$reportNull$$$0(4);
                }
                return returnedList;
            }
        }
        throw new ExceptionWithContext("Invalid element width: %d", this.elementWidth);
    }

    @Override
    public int getCodeUnits() {
        return 4 + (this.elementWidth * this.elementCount + 1) / 2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NonNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                string = "@NonNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dexFile";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jf/dexlib2/dexbacked/instruction/DexBackedArrayPayload";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jf/dexlib2/dexbacked/instruction/DexBackedArrayPayload";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getArrayElements";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

