/*
 * Decompiled with CFR 0.152.
 */
package org.jf.dexlib2.dexbacked;

import android.support.annotation.NonNull;
import com.google.common.io.ByteStreams;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.List;
import org.jf.dexlib2.Opcodes;
import org.jf.dexlib2.dexbacked.BaseDexBuffer;
import org.jf.dexlib2.dexbacked.DexBackedDexFile;
import org.jf.dexlib2.dexbacked.DexReader;
import org.jf.dexlib2.dexbacked.raw.OdexHeaderItem;
import org.jf.dexlib2.dexbacked.util.VariableSizeList;
import org.jf.dexlib2.util.DexUtil;

public class DexBackedOdexFile
extends DexBackedDexFile {
    private static final int DEPENDENCY_COUNT_OFFSET = 12;
    private static final int DEPENDENCY_START_OFFSET = 16;
    private final byte[] odexBuf;

    public DexBackedOdexFile(@NonNull Opcodes opcodes, @NonNull byte[] odexBuf, byte[] dexBuf) {
        if (opcodes == null) {
            DexBackedOdexFile.$$$reportNull$$$0(0);
        }
        if (odexBuf == null) {
            DexBackedOdexFile.$$$reportNull$$$0(1);
        }
        super(opcodes, dexBuf);
        this.odexBuf = odexBuf;
    }

    @Override
    public boolean isOdexFile() {
        return true;
    }

    @Override
    public boolean hasOdexOpcodes() {
        return true;
    }

    @NonNull
    public List<String> getDependencies() {
        int dexOffset = OdexHeaderItem.getDexOffset(this.odexBuf);
        int dependencyOffset = OdexHeaderItem.getDependenciesOffset(this.odexBuf) - dexOffset;
        BaseDexBuffer buf = new BaseDexBuffer(this.buf);
        int dependencyCount = buf.readInt(dependencyOffset + 12);
        VariableSizeList<String> variableSizeList = new VariableSizeList<String>((DexBackedDexFile)this, dependencyOffset + 16, dependencyCount){

            @Override
            protected String readNextItem(@NonNull DexReader reader, int index) {
                if (reader == null) {
                    1.$$$reportNull$$$0(0);
                }
                int length = reader.readInt();
                int offset = reader.getOffset();
                reader.moveRelative(length + 20);
                try {
                    return new String(DexBackedOdexFile.this.buf, offset, length - 1, "US-ASCII");
                }
                catch (UnsupportedEncodingException ex) {
                    throw new RuntimeException(ex);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NonNull parameter '%s' of %s.%s must not be null", "reader", "org/jf/dexlib2/dexbacked/DexBackedOdexFile$1", "readNextItem"));
            }
        };
        if (variableSizeList == null) {
            DexBackedOdexFile.$$$reportNull$$$0(2);
        }
        return variableSizeList;
    }

    @NonNull
    public static DexBackedOdexFile fromInputStream(@NonNull Opcodes opcodes, @NonNull InputStream is) throws IOException {
        if (opcodes == null) {
            DexBackedOdexFile.$$$reportNull$$$0(3);
        }
        if (is == null) {
            DexBackedOdexFile.$$$reportNull$$$0(4);
        }
        DexUtil.verifyOdexHeader(is);
        is.reset();
        byte[] odexBuf = new byte[40];
        ByteStreams.readFully(is, odexBuf);
        int dexOffset = OdexHeaderItem.getDexOffset(odexBuf);
        if (dexOffset > 40) {
            ByteStreams.skipFully(is, dexOffset - 40);
        }
        byte[] dexBuf = ByteStreams.toByteArray(is);
        DexBackedOdexFile dexBackedOdexFile = new DexBackedOdexFile(opcodes, odexBuf, dexBuf);
        if (dexBackedOdexFile == null) {
            DexBackedOdexFile.$$$reportNull$$$0(5);
        }
        return dexBackedOdexFile;
    }

    public int getOdexVersion() {
        return OdexHeaderItem.getVersion(this.odexBuf, 0);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NonNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 5: {
                string = "@NonNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "opcodes";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "odexBuf";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jf/dexlib2/dexbacked/DexBackedOdexFile";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "is";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jf/dexlib2/dexbacked/DexBackedOdexFile";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getDependencies";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "fromInputStream";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 5: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "fromInputStream";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class NotAnOdexFile
    extends RuntimeException {
        public NotAnOdexFile() {
        }

        public NotAnOdexFile(Throwable cause) {
            super(cause);
        }

        public NotAnOdexFile(String message) {
            super(message);
        }

        public NotAnOdexFile(String message, Throwable cause) {
            super(message, cause);
        }
    }
}

