/*
 * Decompiled with CFR 0.152.
 */
package org.jf.dexlib2.builder.instruction;

import android.support.annotation.NonNull;
import org.jf.dexlib2.Format;
import org.jf.dexlib2.Opcode;
import org.jf.dexlib2.builder.BuilderInstruction;
import org.jf.dexlib2.iface.UpdateReference;
import org.jf.dexlib2.iface.instruction.formats.Instruction45cc;
import org.jf.dexlib2.iface.reference.Reference;
import org.jf.dexlib2.util.Preconditions;
import org.jf.dexlib2.writer.builder.DexBuilder;

public class BuilderInstruction45cc
extends BuilderInstruction
implements Instruction45cc,
UpdateReference {
    public static final Format FORMAT = Format.Format45cc;
    protected final int registerCount;
    protected final int registerC;
    protected final int registerD;
    protected final int registerE;
    protected final int registerF;
    protected final int registerG;
    @NonNull
    protected Reference reference;
    @NonNull
    protected Reference reference2;

    public BuilderInstruction45cc(@NonNull Opcode opcode, int registerCount, int registerC, int registerD, int registerE, int registerF, int registerG, @NonNull Reference reference, @NonNull Reference reference2) {
        if (opcode == null) {
            BuilderInstruction45cc.$$$reportNull$$$0(0);
        }
        if (reference == null) {
            BuilderInstruction45cc.$$$reportNull$$$0(1);
        }
        if (reference2 == null) {
            BuilderInstruction45cc.$$$reportNull$$$0(2);
        }
        super(opcode);
        this.registerCount = Preconditions.check35cAnd45ccRegisterCount(registerCount);
        this.registerC = registerCount > 0 ? Preconditions.checkNibbleRegister(registerC) : 0;
        this.registerD = registerCount > 1 ? Preconditions.checkNibbleRegister(registerD) : 0;
        this.registerE = registerCount > 2 ? Preconditions.checkNibbleRegister(registerE) : 0;
        this.registerF = registerCount > 3 ? Preconditions.checkNibbleRegister(registerF) : 0;
        this.registerG = registerCount > 4 ? Preconditions.checkNibbleRegister(registerG) : 0;
        this.reference = reference;
        this.reference2 = reference2;
    }

    @Override
    public int getRegisterCount() {
        return this.registerCount;
    }

    @Override
    public int getRegisterC() {
        return this.registerC;
    }

    @Override
    public int getRegisterD() {
        return this.registerD;
    }

    @Override
    public int getRegisterE() {
        return this.registerE;
    }

    @Override
    public int getRegisterF() {
        return this.registerF;
    }

    @Override
    public int getRegisterG() {
        return this.registerG;
    }

    @Override
    @NonNull
    public Reference getReference() {
        Reference reference = this.reference;
        if (reference == null) {
            BuilderInstruction45cc.$$$reportNull$$$0(3);
        }
        return reference;
    }

    @Override
    public int getReferenceType() {
        return this.opcode.referenceType;
    }

    @Override
    @NonNull
    public Reference getReference2() {
        Reference reference = this.reference2;
        if (reference == null) {
            BuilderInstruction45cc.$$$reportNull$$$0(4);
        }
        return reference;
    }

    @Override
    public int getReferenceType2() {
        return this.opcode.referenceType2;
    }

    @Override
    public Format getFormat() {
        return FORMAT;
    }

    @Override
    public void updateReference(DexBuilder dexBuilder) {
        this.reference = dexBuilder.internReference(this.getReference());
        this.reference2 = dexBuilder.internReference(this.getReference2());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NonNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: {
                string = "@NonNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "opcode";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reference";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reference2";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jf/dexlib2/builder/instruction/BuilderInstruction45cc";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jf/dexlib2/builder/instruction/BuilderInstruction45cc";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getReference";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getReference2";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

