/*
 * Decompiled with CFR 0.152.
 */
package org.jf.dexlib2.builder;

import android.support.annotation.NonNull;
import org.jf.dexlib2.Opcode;
import org.jf.dexlib2.builder.BuilderInstruction;
import org.jf.dexlib2.builder.Label;
import org.jf.dexlib2.iface.instruction.OffsetInstruction;
import org.jf.util.ExceptionWithContext;

public abstract class BuilderOffsetInstruction
extends BuilderInstruction
implements OffsetInstruction {
    @NonNull
    protected final Label target;

    public BuilderOffsetInstruction(@NonNull Opcode opcode, @NonNull Label target) {
        if (opcode == null) {
            BuilderOffsetInstruction.$$$reportNull$$$0(0);
        }
        if (target == null) {
            BuilderOffsetInstruction.$$$reportNull$$$0(1);
        }
        super(opcode);
        this.target = target;
    }

    @Override
    public int getCodeOffset() {
        int codeOffset = this.internalGetCodeOffset();
        if (this.getCodeUnits() == 1) {
            if (codeOffset < -128 || codeOffset > 127) {
                throw new ExceptionWithContext("Invalid instruction offset: %d. Offset must be in [-128, 127]", codeOffset);
            }
        } else if (this.getCodeUnits() == 2 && (codeOffset < Short.MIN_VALUE || codeOffset > Short.MAX_VALUE)) {
            throw new ExceptionWithContext("Invalid instruction offset: %d. Offset must be in [-32768, 32767]", codeOffset);
        }
        return codeOffset;
    }

    int internalGetCodeOffset() {
        return this.target.getCodeAddress() - this.getLocation().getCodeAddress();
    }

    @NonNull
    public Label getTarget() {
        Label label = this.target;
        if (label == null) {
            BuilderOffsetInstruction.$$$reportNull$$$0(2);
        }
        return label;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NonNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NonNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "opcode";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jf/dexlib2/builder/BuilderOffsetInstruction";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jf/dexlib2/builder/BuilderOffsetInstruction";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getTarget";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

