/*
 * Decompiled with CFR 0.152.
 */
package org.jf.dexlib2.base;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.google.common.base.Objects;
import com.google.common.primitives.Ints;
import java.util.Comparator;
import org.jf.dexlib2.base.reference.BaseTypeReference;
import org.jf.dexlib2.iface.ExceptionHandler;
import org.jf.dexlib2.iface.reference.TypeReference;

public abstract class BaseExceptionHandler
implements ExceptionHandler {
    public static final Comparator<ExceptionHandler> BY_EXCEPTION = new Comparator<ExceptionHandler>(){

        @Override
        public int compare(ExceptionHandler o1, ExceptionHandler o2) {
            String exceptionType1 = o1.getExceptionType();
            if (exceptionType1 == null) {
                if (o2.getExceptionType() != null) {
                    return 1;
                }
                return 0;
            }
            String exceptionType2 = o2.getExceptionType();
            if (exceptionType2 == null) {
                return -1;
            }
            return exceptionType1.compareTo(o2.getExceptionType());
        }
    };

    @Override
    @Nullable
    public TypeReference getExceptionTypeReference() {
        final String exceptionType = this.getExceptionType();
        if (exceptionType == null) {
            return null;
        }
        return new BaseTypeReference(){

            @Override
            @NonNull
            public String getType() {
                String string = exceptionType;
                if (string == null) {
                    1.$$$reportNull$$$0(0);
                }
                return string;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NonNull method %s.%s must not return null", "org/jf/dexlib2/base/BaseExceptionHandler$1", "getType"));
            }
        };
    }

    @Override
    public int hashCode() {
        String exceptionType = this.getExceptionType();
        int hashCode = exceptionType == null ? 0 : exceptionType.hashCode();
        return hashCode * 31 + this.getHandlerCodeAddress();
    }

    @Override
    public boolean equals(@Nullable Object o) {
        if (o instanceof ExceptionHandler) {
            ExceptionHandler other = (ExceptionHandler)o;
            return Objects.equal(this.getExceptionType(), other.getExceptionType()) && this.getHandlerCodeAddress() == other.getHandlerCodeAddress();
        }
        return false;
    }

    @Override
    public int compareTo(@NonNull ExceptionHandler o) {
        String exceptionType;
        if (o == null) {
            BaseExceptionHandler.$$$reportNull$$$0(0);
        }
        if ((exceptionType = this.getExceptionType()) == null) {
            if (o.getExceptionType() != null) {
                return 1;
            }
        } else {
            String otherExceptionType = o.getExceptionType();
            if (otherExceptionType == null) {
                return -1;
            }
            int res = exceptionType.compareTo(o.getExceptionType());
            if (res != 0) {
                return res;
            }
        }
        return Ints.compare(this.getHandlerCodeAddress(), o.getHandlerCodeAddress());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NonNull parameter '%s' of %s.%s must not be null", "o", "org/jf/dexlib2/base/BaseExceptionHandler", "compareTo"));
    }
}

