/*
 * Decompiled with CFR 0.152.
 */
package org.jf.dexlib2.analysis;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import java.io.IOException;
import java.io.Writer;
import org.jf.dexlib2.analysis.AnalysisException;
import org.jf.dexlib2.analysis.ClassPath;
import org.jf.dexlib2.analysis.TypeProto;
import org.jf.util.ExceptionWithContext;

public class RegisterType {
    public final byte category;
    @Nullable
    public final TypeProto type;
    public static final byte UNKNOWN = 0;
    public static final byte UNINIT = 1;
    public static final byte NULL = 2;
    public static final byte ONE = 3;
    public static final byte BOOLEAN = 4;
    public static final byte BYTE = 5;
    public static final byte POS_BYTE = 6;
    public static final byte SHORT = 7;
    public static final byte POS_SHORT = 8;
    public static final byte CHAR = 9;
    public static final byte INTEGER = 10;
    public static final byte FLOAT = 11;
    public static final byte LONG_LO = 12;
    public static final byte LONG_HI = 13;
    public static final byte DOUBLE_LO = 14;
    public static final byte DOUBLE_HI = 15;
    public static final byte UNINIT_REF = 16;
    public static final byte UNINIT_THIS = 17;
    public static final byte REFERENCE = 18;
    public static final byte CONFLICTED = 19;
    public static final String[] CATEGORY_NAMES = new String[]{"Unknown", "Uninit", "Null", "One", "Boolean", "Byte", "PosByte", "Short", "PosShort", "Char", "Integer", "Float", "LongLo", "LongHi", "DoubleLo", "DoubleHi", "UninitRef", "UninitThis", "Reference", "Conflicted"};
    protected static byte[][] mergeTable = new byte[][]{{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19}, {1, 1, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19}, {2, 19, 2, 4, 4, 5, 6, 7, 8, 9, 10, 11, 19, 19, 19, 19, 19, 19, 18, 19}, {3, 19, 4, 3, 4, 5, 6, 7, 8, 9, 10, 11, 19, 19, 19, 19, 19, 19, 19, 19}, {4, 19, 4, 4, 4, 5, 6, 7, 8, 9, 10, 11, 19, 19, 19, 19, 19, 19, 19, 19}, {5, 19, 5, 5, 5, 5, 5, 7, 7, 10, 10, 11, 19, 19, 19, 19, 19, 19, 19, 19}, {6, 19, 6, 6, 6, 5, 6, 7, 8, 9, 10, 11, 19, 19, 19, 19, 19, 19, 19, 19}, {7, 19, 7, 7, 7, 7, 7, 7, 7, 10, 10, 11, 19, 19, 19, 19, 19, 19, 19, 19}, {8, 19, 8, 8, 8, 7, 8, 7, 8, 9, 10, 11, 19, 19, 19, 19, 19, 19, 19, 19}, {9, 19, 9, 9, 9, 10, 9, 10, 9, 9, 10, 11, 19, 19, 19, 19, 19, 19, 19, 19}, {10, 19, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 19, 19, 19, 19, 19, 19, 19, 19}, {11, 19, 11, 11, 11, 11, 11, 11, 11, 11, 10, 11, 19, 19, 19, 19, 19, 19, 19, 19}, {12, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 12, 19, 12, 19, 19, 19, 19, 19}, {13, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 13, 19, 13, 19, 19, 19, 19}, {14, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 12, 19, 14, 19, 19, 19, 19, 19}, {15, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 13, 19, 15, 19, 19, 19, 19}, {16, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19}, {17, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 17, 19, 19}, {18, 19, 18, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 18, 19}, {19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19}};
    public static final RegisterType UNKNOWN_TYPE = new RegisterType(0, null);
    public static final RegisterType UNINIT_TYPE = new RegisterType(1, null);
    public static final RegisterType NULL_TYPE = new RegisterType(2, null);
    public static final RegisterType ONE_TYPE = new RegisterType(3, null);
    public static final RegisterType BOOLEAN_TYPE = new RegisterType(4, null);
    public static final RegisterType BYTE_TYPE = new RegisterType(5, null);
    public static final RegisterType POS_BYTE_TYPE = new RegisterType(6, null);
    public static final RegisterType SHORT_TYPE = new RegisterType(7, null);
    public static final RegisterType POS_SHORT_TYPE = new RegisterType(8, null);
    public static final RegisterType CHAR_TYPE = new RegisterType(9, null);
    public static final RegisterType INTEGER_TYPE = new RegisterType(10, null);
    public static final RegisterType FLOAT_TYPE = new RegisterType(11, null);
    public static final RegisterType LONG_LO_TYPE = new RegisterType(12, null);
    public static final RegisterType LONG_HI_TYPE = new RegisterType(13, null);
    public static final RegisterType DOUBLE_LO_TYPE = new RegisterType(14, null);
    public static final RegisterType DOUBLE_HI_TYPE = new RegisterType(15, null);
    public static final RegisterType CONFLICTED_TYPE = new RegisterType(19, null);

    private RegisterType(byte category, @Nullable TypeProto type) {
        assert ((category == 18 || category == 16 || category == 17) && type != null || category != 18 && category != 16 && category != 17 && type == null);
        this.category = category;
        this.type = type;
    }

    public String toString() {
        return "(" + CATEGORY_NAMES[this.category] + (this.type == null ? "" : "," + this.type) + ")";
    }

    public void writeTo(Writer writer) throws IOException {
        writer.write(40);
        writer.write(CATEGORY_NAMES[this.category]);
        if (this.type != null) {
            writer.write(44);
            writer.write(this.type.getType());
        }
        writer.write(41);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RegisterType that = (RegisterType)o;
        if (this.category != that.category) {
            return false;
        }
        if (this.category == 16 || this.category == 17) {
            return false;
        }
        return this.type != null ? this.type.equals(that.type) : that.type == null;
    }

    public int hashCode() {
        int result = this.category;
        result = 31 * result + (this.type != null ? this.type.hashCode() : 0);
        return result;
    }

    @NonNull
    public static RegisterType getWideRegisterType(@NonNull CharSequence type, boolean firstRegister) {
        if (type == null) {
            RegisterType.$$$reportNull$$$0(0);
        }
        switch (type.charAt(0)) {
            case 'J': {
                if (firstRegister) {
                    RegisterType registerType = RegisterType.getRegisterType((byte)12, null);
                    if (registerType == null) {
                        RegisterType.$$$reportNull$$$0(1);
                    }
                    return registerType;
                }
                RegisterType registerType = RegisterType.getRegisterType((byte)13, null);
                if (registerType == null) {
                    RegisterType.$$$reportNull$$$0(2);
                }
                return registerType;
            }
            case 'D': {
                if (firstRegister) {
                    RegisterType registerType = RegisterType.getRegisterType((byte)14, null);
                    if (registerType == null) {
                        RegisterType.$$$reportNull$$$0(3);
                    }
                    return registerType;
                }
                RegisterType registerType = RegisterType.getRegisterType((byte)15, null);
                if (registerType == null) {
                    RegisterType.$$$reportNull$$$0(4);
                }
                return registerType;
            }
        }
        throw new ExceptionWithContext("Cannot use this method for narrow register type: %s", type);
    }

    @NonNull
    public static RegisterType getRegisterType(@NonNull ClassPath classPath, @NonNull CharSequence type) {
        if (classPath == null) {
            RegisterType.$$$reportNull$$$0(5);
        }
        if (type == null) {
            RegisterType.$$$reportNull$$$0(6);
        }
        switch (type.charAt(0)) {
            case 'Z': {
                RegisterType registerType = BOOLEAN_TYPE;
                if (registerType == null) {
                    RegisterType.$$$reportNull$$$0(7);
                }
                return registerType;
            }
            case 'B': {
                RegisterType registerType = BYTE_TYPE;
                if (registerType == null) {
                    RegisterType.$$$reportNull$$$0(8);
                }
                return registerType;
            }
            case 'S': {
                RegisterType registerType = SHORT_TYPE;
                if (registerType == null) {
                    RegisterType.$$$reportNull$$$0(9);
                }
                return registerType;
            }
            case 'C': {
                RegisterType registerType = CHAR_TYPE;
                if (registerType == null) {
                    RegisterType.$$$reportNull$$$0(10);
                }
                return registerType;
            }
            case 'I': {
                RegisterType registerType = INTEGER_TYPE;
                if (registerType == null) {
                    RegisterType.$$$reportNull$$$0(11);
                }
                return registerType;
            }
            case 'F': {
                RegisterType registerType = FLOAT_TYPE;
                if (registerType == null) {
                    RegisterType.$$$reportNull$$$0(12);
                }
                return registerType;
            }
            case 'J': {
                RegisterType registerType = LONG_LO_TYPE;
                if (registerType == null) {
                    RegisterType.$$$reportNull$$$0(13);
                }
                return registerType;
            }
            case 'D': {
                RegisterType registerType = DOUBLE_LO_TYPE;
                if (registerType == null) {
                    RegisterType.$$$reportNull$$$0(14);
                }
                return registerType;
            }
            case 'L': 
            case '[': {
                RegisterType registerType = RegisterType.getRegisterType((byte)18, classPath.getClass(type));
                if (registerType == null) {
                    RegisterType.$$$reportNull$$$0(15);
                }
                return registerType;
            }
        }
        throw new AnalysisException("Invalid type: " + type, new Object[0]);
    }

    @NonNull
    public static RegisterType getRegisterTypeForLiteral(int literalValue) {
        if (literalValue < Short.MIN_VALUE) {
            RegisterType registerType = INTEGER_TYPE;
            if (registerType == null) {
                RegisterType.$$$reportNull$$$0(16);
            }
            return registerType;
        }
        if (literalValue < -128) {
            RegisterType registerType = SHORT_TYPE;
            if (registerType == null) {
                RegisterType.$$$reportNull$$$0(17);
            }
            return registerType;
        }
        if (literalValue < 0) {
            RegisterType registerType = BYTE_TYPE;
            if (registerType == null) {
                RegisterType.$$$reportNull$$$0(18);
            }
            return registerType;
        }
        if (literalValue == 0) {
            RegisterType registerType = NULL_TYPE;
            if (registerType == null) {
                RegisterType.$$$reportNull$$$0(19);
            }
            return registerType;
        }
        if (literalValue == 1) {
            RegisterType registerType = ONE_TYPE;
            if (registerType == null) {
                RegisterType.$$$reportNull$$$0(20);
            }
            return registerType;
        }
        if (literalValue < 128) {
            RegisterType registerType = POS_BYTE_TYPE;
            if (registerType == null) {
                RegisterType.$$$reportNull$$$0(21);
            }
            return registerType;
        }
        if (literalValue < 32768) {
            RegisterType registerType = POS_SHORT_TYPE;
            if (registerType == null) {
                RegisterType.$$$reportNull$$$0(22);
            }
            return registerType;
        }
        if (literalValue < 65536) {
            RegisterType registerType = CHAR_TYPE;
            if (registerType == null) {
                RegisterType.$$$reportNull$$$0(23);
            }
            return registerType;
        }
        RegisterType registerType = INTEGER_TYPE;
        if (registerType == null) {
            RegisterType.$$$reportNull$$$0(24);
        }
        return registerType;
    }

    @NonNull
    public RegisterType merge(@NonNull RegisterType other) {
        if (other == null) {
            RegisterType.$$$reportNull$$$0(25);
        }
        if (other.equals(this)) {
            RegisterType registerType = this;
            if (registerType == null) {
                RegisterType.$$$reportNull$$$0(26);
            }
            return registerType;
        }
        byte mergedCategory = mergeTable[this.category][other.category];
        TypeProto mergedType = null;
        if (mergedCategory == 18) {
            TypeProto type = this.type;
            mergedType = type != null ? (other.type != null ? type.getCommonSuperclass(other.type) : type) : other.type;
        } else if (mergedCategory == 16 || mergedCategory == 17) {
            if (this.category == 0) {
                RegisterType registerType = other;
                if (registerType == null) {
                    RegisterType.$$$reportNull$$$0(27);
                }
                return registerType;
            }
            assert (other.category == 0);
            RegisterType registerType = this;
            if (registerType == null) {
                RegisterType.$$$reportNull$$$0(28);
            }
            return registerType;
        }
        if (mergedType != null) {
            if (mergedType.equals(this.type)) {
                RegisterType registerType = this;
                if (registerType == null) {
                    RegisterType.$$$reportNull$$$0(29);
                }
                return registerType;
            }
            if (mergedType.equals(other.type)) {
                RegisterType registerType = other;
                if (registerType == null) {
                    RegisterType.$$$reportNull$$$0(30);
                }
                return registerType;
            }
        }
        RegisterType registerType = RegisterType.getRegisterType(mergedCategory, mergedType);
        if (registerType == null) {
            RegisterType.$$$reportNull$$$0(31);
        }
        return registerType;
    }

    @NonNull
    public static RegisterType getRegisterType(byte category, @Nullable TypeProto typeProto) {
        switch (category) {
            case 0: {
                RegisterType registerType = UNKNOWN_TYPE;
                if (registerType == null) {
                    RegisterType.$$$reportNull$$$0(32);
                }
                return registerType;
            }
            case 1: {
                RegisterType registerType = UNINIT_TYPE;
                if (registerType == null) {
                    RegisterType.$$$reportNull$$$0(33);
                }
                return registerType;
            }
            case 2: {
                RegisterType registerType = NULL_TYPE;
                if (registerType == null) {
                    RegisterType.$$$reportNull$$$0(34);
                }
                return registerType;
            }
            case 3: {
                RegisterType registerType = ONE_TYPE;
                if (registerType == null) {
                    RegisterType.$$$reportNull$$$0(35);
                }
                return registerType;
            }
            case 4: {
                RegisterType registerType = BOOLEAN_TYPE;
                if (registerType == null) {
                    RegisterType.$$$reportNull$$$0(36);
                }
                return registerType;
            }
            case 5: {
                RegisterType registerType = BYTE_TYPE;
                if (registerType == null) {
                    RegisterType.$$$reportNull$$$0(37);
                }
                return registerType;
            }
            case 6: {
                RegisterType registerType = POS_BYTE_TYPE;
                if (registerType == null) {
                    RegisterType.$$$reportNull$$$0(38);
                }
                return registerType;
            }
            case 7: {
                RegisterType registerType = SHORT_TYPE;
                if (registerType == null) {
                    RegisterType.$$$reportNull$$$0(39);
                }
                return registerType;
            }
            case 8: {
                RegisterType registerType = POS_SHORT_TYPE;
                if (registerType == null) {
                    RegisterType.$$$reportNull$$$0(40);
                }
                return registerType;
            }
            case 9: {
                RegisterType registerType = CHAR_TYPE;
                if (registerType == null) {
                    RegisterType.$$$reportNull$$$0(41);
                }
                return registerType;
            }
            case 10: {
                RegisterType registerType = INTEGER_TYPE;
                if (registerType == null) {
                    RegisterType.$$$reportNull$$$0(42);
                }
                return registerType;
            }
            case 11: {
                RegisterType registerType = FLOAT_TYPE;
                if (registerType == null) {
                    RegisterType.$$$reportNull$$$0(43);
                }
                return registerType;
            }
            case 12: {
                RegisterType registerType = LONG_LO_TYPE;
                if (registerType == null) {
                    RegisterType.$$$reportNull$$$0(44);
                }
                return registerType;
            }
            case 13: {
                RegisterType registerType = LONG_HI_TYPE;
                if (registerType == null) {
                    RegisterType.$$$reportNull$$$0(45);
                }
                return registerType;
            }
            case 14: {
                RegisterType registerType = DOUBLE_LO_TYPE;
                if (registerType == null) {
                    RegisterType.$$$reportNull$$$0(46);
                }
                return registerType;
            }
            case 15: {
                RegisterType registerType = DOUBLE_HI_TYPE;
                if (registerType == null) {
                    RegisterType.$$$reportNull$$$0(47);
                }
                return registerType;
            }
            case 19: {
                RegisterType registerType = CONFLICTED_TYPE;
                if (registerType == null) {
                    RegisterType.$$$reportNull$$$0(48);
                }
                return registerType;
            }
        }
        RegisterType registerType = new RegisterType(category, typeProto);
        if (registerType == null) {
            RegisterType.$$$reportNull$$$0(49);
        }
        return registerType;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NonNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: {
                string = "@NonNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jf/dexlib2/analysis/RegisterType";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classPath";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "other";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jf/dexlib2/analysis/RegisterType";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getWideRegisterType";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: {
                objectArray = objectArray2;
                objectArray2[1] = "getRegisterType";
                break;
            }
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "getRegisterTypeForLiteral";
                break;
            }
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "merge";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getWideRegisterType";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: {
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getRegisterType";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "merge";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

