/*
 * Decompiled with CFR 0.152.
 */
package cc.binmt.signature;

import bin.signer.ApkSigner;
import bin.signer.key.KeystoreKey;
import bin.util.StreamUtil;
import bin.xml.decode.AXmlDecoder;
import bin.xml.decode.AXmlResourceParser;
import bin.zip.ZipEntry;
import bin.zip.ZipFile;
import bin.zip.ZipOutputStream;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Enumeration;
import java.util.Properties;
import org.jf.dexlib2.Opcodes;
import org.jf.dexlib2.dexbacked.DexBackedClassDef;
import org.jf.dexlib2.dexbacked.DexBackedDexFile;
import org.jf.dexlib2.iface.ClassDef;
import org.jf.dexlib2.writer.builder.DexBuilder;
import org.jf.dexlib2.writer.io.MemoryDataStore;
import org.jf.smali.Smali;
import org.jf.smali.SmaliOptions;
import sun.security.pkcs.PKCS7;

public class NKillSignatureTool {
    private static boolean customApplication = false;
    private static String customApplicationName;
    private static String packageName;
    private static byte[] signatures;

    public static void main(String[] args) throws Exception {
        NKillSignatureTool.process();
    }

    private static void process() throws Exception {
        Properties properties = new Properties();
        try (FileInputStream fis = new FileInputStream("config.txt");){
            properties.load(fis);
        }
        File srcApk = new File(properties.getProperty("apk.src"));
        File signApk = new File(properties.getProperty("apk.signed"));
        File outApk = new File(properties.getProperty("apk.out"));
        boolean signEnable = properties.getProperty("sign.enable").equalsIgnoreCase("true");
        String signFile = properties.getProperty("sign.file");
        String signPassword = properties.getProperty("sign.password");
        String signAlias = properties.getProperty("sign.alias");
        String signAliasPassword = properties.getProperty("sign.aliasPassword");
        System.out.println("\u6b63\u5728\u8bfb\u53d6\u7b7e\u540d\uff1a" + signApk.getPath());
        signatures = NKillSignatureTool.getApkSignatureData(signApk);
        System.out.println("\n\u6b63\u5728\u8bfb\u53d6APK\uff1a" + srcApk.getPath());
        try (ZipFile zipFile = new ZipFile(srcApk);){
            System.out.println("  --\u6b63\u5728\u5904\u7406AndroidManifest.xml");
            ZipEntry manifestEntry = zipFile.getEntry("AndroidManifest.xml");
            byte[] manifestData = NKillSignatureTool.parseManifest(zipFile.getInputStream(manifestEntry));
            ZipEntry dexEntry = zipFile.getEntry("classes.dex");
            DexBackedDexFile dex = DexBackedDexFile.fromInputStream(Opcodes.getDefault(), new BufferedInputStream(zipFile.getInputStream(dexEntry)));
            System.out.println("  --\u6b63\u5728\u5904\u7406classes.dex");
            byte[] dexData = NKillSignatureTool.processDex(dex);
            System.out.println("\n\u6b63\u5728\u5199\u51faAPK\uff1a" + outApk.getPath());
            try (ZipOutputStream zos = new ZipOutputStream(outApk);){
                zos.putNextEntry("AndroidManifest.xml");
                zos.write(manifestData);
                zos.closeEntry();
                zos.putNextEntry("classes.dex");
                zos.write(dexData);
                zos.closeEntry();
                Enumeration<ZipEntry> enumeration = zipFile.getEntries();
                while (enumeration.hasMoreElements()) {
                    ZipEntry ze = enumeration.nextElement();
                    if (ze.getName().equals("AndroidManifest.xml") || ze.getName().equals("classes.dex") || ze.getName().startsWith("META-INF/")) continue;
                    zos.copyZipEntry(ze, zipFile);
                }
            }
            if (signEnable) {
                System.out.println("\n\u6b63\u5728\u7b7e\u540dAPK\uff1a" + outApk.getPath());
                KeystoreKey keystoreKey = new KeystoreKey(signFile, signPassword, signAlias, signAliasPassword);
                File temp = new File(outApk.getPath() + ".tmp");
                ApkSigner.signApk(outApk, temp, keystoreKey, null);
                outApk.delete();
                temp.renameTo(outApk);
            }
            System.out.println("\n\u5904\u7406\u5b8c\u6210");
        }
    }

    private static byte[] processDex(DexBackedDexFile dex) throws Exception {
        DexBuilder dexBuilder = new DexBuilder(Opcodes.getDefault());
        try (InputStream fis = NKillSignatureTool.class.getResourceAsStream("PmsHookApplication.smali");){
            String src = new String(StreamUtil.readBytes(fis), "utf-8");
            if (customApplication) {
                if (customApplicationName.startsWith(".")) {
                    if (packageName == null) {
                        throw new NullPointerException("Package name is null.");
                    }
                    customApplicationName = packageName + customApplicationName;
                }
                customApplicationName = "L" + customApplicationName.replace('.', '/') + ";";
                src = src.replace("Landroid/app/Application;", customApplicationName);
            }
            if (signatures == null) {
                throw new NullPointerException("Signatures is null");
            }
            ClassDef classDef = Smali.assembleSmaliFile(src = src.replace("### Signatures Data ###", Base64.getEncoder().encodeToString(signatures)), dexBuilder, new SmaliOptions());
            if (classDef == null) {
                throw new Exception("Parse smali failed");
            }
            for (DexBackedClassDef dexBackedClassDef : dex.getClasses()) {
                dexBuilder.internClassDef(dexBackedClassDef);
            }
        }
        MemoryDataStore store = new MemoryDataStore();
        dexBuilder.writeTo(store);
        return Arrays.copyOf(store.getBufferData(), store.getSize());
    }

    private static byte[] parseManifest(InputStream is) throws IOException {
        int type;
        AXmlDecoder axml = AXmlDecoder.decode(is);
        AXmlResourceParser parser = new AXmlResourceParser();
        parser.open(new ByteArrayInputStream(axml.getData()), axml.mTableStrings);
        boolean success = false;
        while ((type = parser.next()) != 1) {
            int i;
            int size;
            if (type != 2) continue;
            if (parser.getName().equals("manifest")) {
                size = parser.getAttributeCount();
                for (i = 0; i < size; ++i) {
                    if (!parser.getAttributeName(i).equals("package")) continue;
                    packageName = parser.getAttributeValue(i);
                }
                continue;
            }
            if (!parser.getName().equals("application")) continue;
            size = parser.getAttributeCount();
            for (i = 0; i < size; ++i) {
                if (parser.getAttributeNameResource(i) != 0x1010003) continue;
                customApplication = true;
                customApplicationName = parser.getAttributeValue(i);
                int index = axml.mTableStrings.getSize();
                byte[] data = axml.getData();
                int off = parser.currentAttributeStart + 20 * i;
                NKillSignatureTool.writeInt(data, off += 8, index);
                NKillSignatureTool.writeInt(data, off += 8, index);
            }
            if (!customApplication) {
                int off = parser.currentAttributeStart;
                byte[] data = axml.getData();
                byte[] newData = new byte[data.length + 20];
                System.arraycopy(data, 0, newData, 0, off);
                System.arraycopy(data, off, newData, off + 20, data.length - off);
                int chunkSize = NKillSignatureTool.readInt(newData, off - 32);
                NKillSignatureTool.writeInt(newData, off - 32, chunkSize + 20);
                NKillSignatureTool.writeInt(newData, off - 8, size + 1);
                int idIndex = parser.findResourceID(0x1010003);
                if (idIndex == -1) {
                    throw new IOException("idIndex == -1");
                }
                boolean isMax = true;
                for (int i2 = 0; i2 < size; ++i2) {
                    int id = parser.getAttributeNameResource(i2);
                    if (id <= 0x1010003) continue;
                    isMax = false;
                    if (i2 == 0) break;
                    System.arraycopy(newData, off + 20, newData, off, 20 * i2);
                    off += 20 * i2;
                    break;
                }
                if (isMax) {
                    System.arraycopy(newData, off + 20, newData, off, 20 * size);
                    off += 20 * size;
                }
                NKillSignatureTool.writeInt(newData, off, axml.mTableStrings.find("http://schemas.android.com/apk/res/android"));
                NKillSignatureTool.writeInt(newData, off + 4, idIndex);
                NKillSignatureTool.writeInt(newData, off + 8, axml.mTableStrings.getSize());
                NKillSignatureTool.writeInt(newData, off + 12, 0x3000008);
                NKillSignatureTool.writeInt(newData, off + 16, axml.mTableStrings.getSize());
                axml.setData(newData);
            }
            success = true;
            break;
        }
        if (!success) {
            throw new IOException();
        }
        ArrayList<String> list = new ArrayList<String>(axml.mTableStrings.getSize());
        axml.mTableStrings.getStrings(list);
        list.add("cc.binmt.signature.PmsHookApplication");
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        axml.write(list, baos);
        return baos.toByteArray();
    }

    private static void writeInt(byte[] data, int off, int value) {
        data[off++] = (byte)(value & 0xFF);
        data[off++] = (byte)(value >>> 8 & 0xFF);
        data[off++] = (byte)(value >>> 16 & 0xFF);
        data[off] = (byte)(value >>> 24 & 0xFF);
    }

    private static int readInt(byte[] data, int off) {
        return data[off + 3] << 24 | (data[off + 2] & 0xFF) << 16 | (data[off + 1] & 0xFF) << 8 | data[off] & 0xFF;
    }

    private static byte[] getApkSignatureData(File apkFile) throws Exception {
        ZipFile zipFile = new ZipFile(apkFile);
        Enumeration<ZipEntry> entries = zipFile.getEntries();
        while (entries.hasMoreElements()) {
            ZipEntry ze = entries.nextElement();
            String name = ze.getName().toUpperCase();
            if (!name.startsWith("META-INF/") || !name.endsWith(".RSA") && !name.endsWith(".DSA")) continue;
            PKCS7 pkcs7 = new PKCS7(StreamUtil.readBytes(zipFile.getInputStream(ze)));
            X509Certificate[] certs = pkcs7.getCertificates();
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            DataOutputStream dos = new DataOutputStream(baos);
            dos.write(certs.length);
            for (int i = 0; i < certs.length; ++i) {
                byte[] data = certs[i].getEncoded();
                System.out.printf("  --SignatureHash[%d]: %08x\n", i, Arrays.hashCode(data));
                dos.writeInt(data.length);
                dos.write(data);
            }
            return baos.toByteArray();
        }
        throw new Exception("META-INF/XXX.RSA (DSA) file not found.");
    }
}

