/*
 * Decompiled with CFR 0.152.
 */
package bin.zip.encoding;

import bin.zip.encoding.DetectEncoding;
import bin.zip.encoding.ZipEncoding;
import java.io.IOException;
import java.nio.ByteBuffer;

class FallbackZipEncoding
implements ZipEncoding {
    private final String charset;
    private final DetectEncoding de;

    public FallbackZipEncoding() {
        this.charset = null;
        this.de = new DetectEncoding();
    }

    public FallbackZipEncoding(String charset) {
        this.charset = charset;
        this.de = charset != null ? null : new DetectEncoding();
    }

    @Override
    public boolean canEncode(String name) {
        return true;
    }

    @Override
    public ByteBuffer encode(String name) throws IOException {
        if (this.charset == null) {
            return ByteBuffer.wrap(name.getBytes(this.de.getEncode()));
        }
        return ByteBuffer.wrap(name.getBytes(this.charset));
    }

    @Override
    public String decode(byte[] data) throws IOException {
        if (this.charset == null) {
            this.de.update(data);
            return new String(data, this.de.getEncode());
        }
        return new String(data, this.charset);
    }

    @Override
    public String getEncoding() {
        if (this.charset == null) {
            return this.de.getEncode().name();
        }
        return this.charset;
    }
}

