/*
 * Decompiled with CFR 0.152.
 */
package bin.io;

import java.io.IOException;
import java.io.OutputStream;

public final class ZOutput {
    private int written = 0;
    private OutputStream dos;

    public ZOutput(OutputStream out) {
        this.dos = out;
    }

    public final void writeShort(short s) throws IOException {
        this.dos.write(s & 0xFF);
        ++this.written;
        this.dos.write(s >>> 8 & 0xFF);
        ++this.written;
    }

    public void close() throws IOException {
        this.dos.close();
    }

    public int size() {
        return this.written;
    }

    public final void writeChar(char c) throws IOException {
        this.dos.write(c & 0xFF);
        ++this.written;
        this.dos.write(c >>> 8 & 0xFF);
        ++this.written;
    }

    public final void writeCharArray(char[] c) throws IOException {
        for (char element : c) {
            this.writeChar(element);
        }
    }

    public final void write(int i) throws IOException {
        this.dos.write(i);
        ++this.written;
    }

    public final void writeByte(int b) throws IOException {
        this.dos.write(b);
        ++this.written;
    }

    public final void writeFully(byte[] b) throws IOException {
        this.dos.write(b, 0, b.length);
        this.written += b.length;
    }

    public final void writeFully(byte[] b, int a, int len) throws IOException {
        this.dos.write(b, a, len);
        this.written += len;
    }

    public final void writeInt(int i) throws IOException {
        this.dos.write(i & 0xFF);
        ++this.written;
        this.dos.write(i >>> 8 & 0xFF);
        ++this.written;
        this.dos.write(i >>> 16 & 0xFF);
        ++this.written;
        this.dos.write(i >>> 24 & 0xFF);
        ++this.written;
    }

    public final void writeIntArray(int[] buf, int s, int end) throws IOException {
        while (s < end) {
            this.writeInt(buf[s]);
            ++s;
        }
    }

    public final void writeIntArray(int[] buf) throws IOException {
        this.writeIntArray(buf, 0, buf.length);
    }

    public final void writeNulEndedString(String string, int length, boolean fixed) throws IOException {
        char[] ch = string.toCharArray();
        int j = 0;
        while (j < ch.length && length != 0) {
            this.writeChar(ch[j++]);
            --length;
        }
        if (fixed) {
            for (int i = 0; i < length * 2; ++i) {
                this.dos.write(0);
                ++this.written;
            }
        }
    }
}

