/*
 * Decompiled with CFR 0.152.
 */
package cn.wjdiankong.main;

import cn.wjdiankong.chunk.EndNameSpaceChunk;
import cn.wjdiankong.chunk.EndTagChunk;
import cn.wjdiankong.chunk.ResourceChunk;
import cn.wjdiankong.chunk.StartNameSpaceChunk;
import cn.wjdiankong.chunk.StartTagChunk;
import cn.wjdiankong.chunk.StringChunk;
import cn.wjdiankong.chunk.TagChunk;
import cn.wjdiankong.chunk.TextChunk;
import cn.wjdiankong.chunk.XmlStruct;
import cn.wjdiankong.main.Utils;
import cn.wjdiankong.main.XmlEditor;
import java.util.ArrayList;
import java.util.List;

public class ParserChunkUtils {
    public static int stringChunkOffset = 8;
    public static int resourceChunkOffset;
    public static int nextChunkOffset;
    public static XmlStruct xmlStruct;
    public static boolean isApplication;
    public static boolean isManifest;
    public static List<TagChunk> tagChunkList;

    static {
        xmlStruct = new XmlStruct();
        isApplication = false;
        isManifest = false;
        tagChunkList = new ArrayList<TagChunk>();
    }

    public static void clear() {
        resourceChunkOffset = 0;
        nextChunkOffset = 0;
        isApplication = false;
        isManifest = false;
        tagChunkList.clear();
        xmlStruct.clear();
    }

    public static void parserXml() {
        ParserChunkUtils.clear();
        ParserChunkUtils.parserXmlHeader(ParserChunkUtils.xmlStruct.byteSrc);
        ParserChunkUtils.parserStringChunk(ParserChunkUtils.xmlStruct.byteSrc);
        ParserChunkUtils.parserResourceChunk(ParserChunkUtils.xmlStruct.byteSrc);
        ParserChunkUtils.parserXmlContent(ParserChunkUtils.xmlStruct.byteSrc);
    }

    public static void parserXmlHeader(byte[] byteSrc) {
        byte[] xmlMagic = Utils.copyByte(byteSrc, 0, 4);
        byte[] xmlSize = Utils.copyByte(byteSrc, 4, 4);
        ParserChunkUtils.xmlStruct.magicNumber = xmlMagic;
        ParserChunkUtils.xmlStruct.fileSize = xmlSize;
    }

    public static void parserStringChunk(byte[] byteSrc) {
        ParserChunkUtils.xmlStruct.stringChunk = StringChunk.createChunk(byteSrc, stringChunkOffset);
        byte[] chunkSizeByte = Utils.copyByte(byteSrc, 12, 4);
        resourceChunkOffset = stringChunkOffset + Utils.byte2int(chunkSizeByte);
    }

    public static void parserResourceChunk(byte[] byteSrc) {
        ParserChunkUtils.xmlStruct.resChunk = ResourceChunk.createChunk(byteSrc, resourceChunkOffset);
        byte[] chunkSizeByte = Utils.copyByte(byteSrc, resourceChunkOffset + 4, 4);
        int chunkSize = Utils.byte2int(chunkSizeByte);
        XmlEditor.tagStartChunkOffset = nextChunkOffset = resourceChunkOffset + chunkSize;
    }

    public static void parserStartNamespaceChunk(byte[] byteSrc) {
        ParserChunkUtils.xmlStruct.startNamespaceChunk = StartNameSpaceChunk.createChunk(byteSrc);
    }

    public static void parserEndNamespaceChunk(byte[] byteSrc) {
        ParserChunkUtils.xmlStruct.endNamespaceChunk = EndNameSpaceChunk.createChunk(byteSrc);
    }

    public static void parserStartTagChunk(byte[] byteSrc, int offset) {
        StartTagChunk tagChunk = StartTagChunk.createChunk(byteSrc, offset);
        ParserChunkUtils.xmlStruct.startTagChunkList.add(tagChunk);
        TagChunk chunk = new TagChunk();
        chunk.startTagChunk = tagChunk;
        tagChunkList.add(chunk);
        byte[] tagNameByte = Utils.copyByte(byteSrc, 20, 4);
        int tagNameIndex = Utils.byte2int(tagNameByte);
        String tagName = ParserChunkUtils.xmlStruct.stringChunk.stringContentList.get(tagNameIndex);
        if (tagName.equals("application")) {
            isApplication = true;
        }
    }

    public static void parserEndTagChunk(byte[] byteSrc, int offset) {
        EndTagChunk tagChunk = EndTagChunk.createChunk(byteSrc, offset);
        TagChunk chunk = tagChunkList.remove(tagChunkList.size() - 1);
        chunk.endTagChunk = tagChunk;
        ParserChunkUtils.xmlStruct.endTagChunkList.add(tagChunk);
        ParserChunkUtils.xmlStruct.tagChunkList.add(chunk);
    }

    public static void parserTextChunk(byte[] byteSrc) {
        ParserChunkUtils.xmlStruct.textChunkList.add(TextChunk.createChunk(byteSrc));
    }

    public static void parserXmlContent(byte[] byteSrc) {
        while (!ParserChunkUtils.isEnd(byteSrc.length)) {
            byte[] chunkTagByte = Utils.copyByte(byteSrc, nextChunkOffset, 4);
            byte[] chunkSizeByte = Utils.copyByte(byteSrc, nextChunkOffset + 4, 4);
            int chunkTag = Utils.byte2int(chunkTagByte);
            int chunkSize = Utils.byte2int(chunkSizeByte);
            switch (chunkTag) {
                case 0x100100: {
                    ParserChunkUtils.parserStartNamespaceChunk(Utils.copyByte(byteSrc, nextChunkOffset, chunkSize));
                    isManifest = true;
                    break;
                }
                case 0x100102: {
                    ParserChunkUtils.parserStartTagChunk(Utils.copyByte(byteSrc, nextChunkOffset, chunkSize), nextChunkOffset);
                    if (isApplication) {
                        XmlEditor.subAppTagChunkOffset = nextChunkOffset + chunkSize;
                        isApplication = false;
                    }
                    if (!isManifest) break;
                    XmlEditor.subTagChunkOffsets = nextChunkOffset + chunkSize;
                    isManifest = false;
                    break;
                }
                case 0x100103: {
                    ParserChunkUtils.parserEndTagChunk(Utils.copyByte(byteSrc, nextChunkOffset, chunkSize), nextChunkOffset);
                    break;
                }
                case 0x100101: {
                    ParserChunkUtils.parserEndNamespaceChunk(Utils.copyByte(byteSrc, nextChunkOffset, chunkSize));
                }
            }
            nextChunkOffset += chunkSize;
        }
    }

    public static boolean isEnd(int totalLen) {
        return nextChunkOffset >= totalLen;
    }
}

