/*
 * Decompiled with CFR 0.152.
 */
package cn.wjdiankong.chunk;

import cn.wjdiankong.main.Utils;
import java.util.ArrayList;

public class StringChunk {
    public byte[] type;
    public byte[] size;
    public byte[] strCount;
    public byte[] styleCount;
    public byte[] unknown;
    public byte[] strPoolOffset;
    public byte[] stylePoolOffset;
    public byte[] strOffsets;
    public byte[] styleOffsets;
    public byte[] strPool;
    public byte[] stylePool;
    public ArrayList<String> stringContentList;

    public byte[] getByte(ArrayList<String> strList) {
        byte[] strB = this.getStrListByte(strList);
        byte[] src = new byte[]{};
        src = Utils.addByte(src, this.type);
        src = Utils.addByte(src, this.size);
        src = Utils.addByte(src, Utils.int2Byte(strList.size()));
        src = Utils.addByte(src, this.styleCount);
        src = Utils.addByte(src, this.unknown);
        src = Utils.addByte(src, this.strPoolOffset);
        src = Utils.addByte(src, this.stylePoolOffset);
        byte[] strOffsets = new byte[]{};
        ArrayList<String> convertList = this.convertStrList(strList);
        int len = 0;
        int i = 0;
        while (i < convertList.size()) {
            strOffsets = Utils.addByte(strOffsets, Utils.int2Byte(len));
            len += convertList.get(i).length() + 4;
            ++i;
        }
        src = Utils.addByte(src, strOffsets);
        int newStyleOffsets = src.length;
        src = Utils.addByte(src, this.styleOffsets);
        int newStringPools = src.length;
        src = Utils.addByte(src, strB);
        src = Utils.addByte(src, this.stylePool);
        if (this.styleOffsets != null && this.styleOffsets.length > 0) {
            src = Utils.replaceBytes(src, Utils.int2Byte(newStyleOffsets), 28 + strList.size() * 4);
        }
        if ((src = Utils.replaceBytes(src, Utils.int2Byte(newStringPools), 20)).length % 4 != 0) {
            src = Utils.addByte(src, new byte[2]);
        }
        src = Utils.replaceBytes(src, Utils.int2Byte(src.length), 4);
        return src;
    }

    public int getLen() {
        return this.type.length + this.size.length + this.strCount.length + this.styleCount.length + this.unknown.length + this.strPoolOffset.length + this.stylePoolOffset.length + this.strOffsets.length + this.styleOffsets.length + this.strPool.length + this.stylePool.length;
    }

    public static StringChunk createChunk(byte[] byteSrc, int stringChunkOffset) {
        StringChunk chunk = new StringChunk();
        chunk.type = Utils.copyByte(byteSrc, 0 + stringChunkOffset, 4);
        chunk.size = Utils.copyByte(byteSrc, 4 + stringChunkOffset, 4);
        int chunkSize = Utils.byte2int(chunk.size);
        chunk.strCount = Utils.copyByte(byteSrc, 8 + stringChunkOffset, 4);
        int chunkStringCount = Utils.byte2int(chunk.strCount);
        chunk.stringContentList = new ArrayList(chunkStringCount);
        chunk.styleCount = Utils.copyByte(byteSrc, 12 + stringChunkOffset, 4);
        int chunkStyleCount = Utils.byte2int(chunk.styleCount);
        chunk.unknown = Utils.copyByte(byteSrc, 16 + stringChunkOffset, 4);
        chunk.strPoolOffset = Utils.copyByte(byteSrc, 20 + stringChunkOffset, 4);
        chunk.stylePoolOffset = Utils.copyByte(byteSrc, 24 + stringChunkOffset, 4);
        chunk.strOffsets = Utils.copyByte(byteSrc, 28 + stringChunkOffset, 4 * chunkStringCount);
        chunk.styleOffsets = Utils.copyByte(byteSrc, 28 + stringChunkOffset + 4 * chunkStringCount, 4 * chunkStyleCount);
        int stringContentStart = 8 + Utils.byte2int(chunk.strPoolOffset);
        byte[] chunkStringContentByte = Utils.copyByte(byteSrc, stringContentStart, chunkSize);
        byte[] firstStringSizeByte = Utils.copyByte(chunkStringContentByte, 0, 2);
        int firstStringSize = Utils.byte2Short(firstStringSizeByte) * 2;
        byte[] firstStringContentByte = Utils.copyByte(chunkStringContentByte, 2, firstStringSize + 2);
        String firstStringContent = new String(firstStringContentByte);
        chunk.stringContentList.add(Utils.filterStringNull(firstStringContent));
        int endStringIndex = 2 + firstStringSize + 2;
        while (chunk.stringContentList.size() < chunkStringCount) {
            int stringSize = Utils.byte2Short(Utils.copyByte(chunkStringContentByte, endStringIndex, 2)) * 2;
            byte[] temp = Utils.copyByte(chunkStringContentByte, endStringIndex + 2, stringSize + 2);
            String str = new String(temp);
            chunk.stringContentList.add(Utils.filterStringNull(str));
            endStringIndex += 2 + stringSize + 2;
        }
        int len = 0;
        for (String str : chunk.stringContentList) {
            len += 2;
            len += str.length() * 2;
            len += 2;
        }
        chunk.strPool = Utils.copyByte(byteSrc, stringContentStart, len);
        int stylePool = stringContentStart + len;
        chunk.stylePool = Utils.copyByte(byteSrc, stylePool, chunkSize - stylePool);
        return chunk;
    }

    private byte[] getStrListByte(ArrayList<String> strList) {
        byte[] src = new byte[]{};
        ArrayList<String> stringContentList = this.convertStrList(strList);
        int i = 0;
        while (i < stringContentList.size()) {
            byte[] tempAry = new byte[]{};
            short len = (short)(stringContentList.get(i).length() / 2);
            byte[] lenAry = Utils.shortToByte(len);
            tempAry = Utils.addByte(tempAry, lenAry);
            tempAry = Utils.addByte(tempAry, stringContentList.get(i).getBytes());
            tempAry = Utils.addByte(tempAry, new byte[2]);
            src = Utils.addByte(src, tempAry);
            ++i;
        }
        return src;
    }

    private ArrayList<String> convertStrList(ArrayList<String> stringContentList) {
        ArrayList<String> destList = new ArrayList<String>(stringContentList.size());
        for (String str : stringContentList) {
            byte[] temp = str.getBytes();
            byte[] src = new byte[temp.length * 2];
            int i = 0;
            while (i < temp.length) {
                src[i * 2] = temp[i];
                src[i * 2 + 1] = 0;
                ++i;
            }
            destList.add(new String(src));
        }
        return destList;
    }
}

