/*
 * Decompiled with CFR 0.152.
 */
package com.zhh.jiagu.shell.util;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import net.lingala.zip4j.ZipFile;
import net.lingala.zip4j.exception.ZipException;
import net.lingala.zip4j.model.FileHeader;
import net.lingala.zip4j.model.ZipParameters;
import net.lingala.zip4j.model.enums.CompressionLevel;
import net.lingala.zip4j.model.enums.CompressionMethod;

public class Zip4jUtil {
    public static void zipFiles(File[] files, File outZip) throws ZipException {
        if (files == null || files.length <= 0) {
            return;
        }
        ZipFile zipFile = new ZipFile(outZip);
        ZipParameters parameters = new ZipParameters();
        parameters.setCompressionMethod(CompressionMethod.DEFLATE);
        parameters.setCompressionLevel(CompressionLevel.NORMAL);
        for (File f : files) {
            if (f.isDirectory()) {
                zipFile.addFolder(f, parameters);
                continue;
            }
            zipFile.addFile(f, parameters);
        }
    }

    private static void unzip(File inputFile, File outFile) {
        try {
            ZipFile zipFile = new ZipFile(inputFile);
            zipFile.extractAll(outFile.getAbsolutePath());
        }
        catch (ZipException e) {
            e.printStackTrace();
        }
    }

    public static void extractFile(String zip, String fileName, String outDir) {
        try {
            ZipFile zipFile = new ZipFile(zip);
            zipFile.extractFile(fileName, outDir);
        }
        catch (ZipException e) {
            e.printStackTrace();
        }
    }

    public static void addFile2Zip(String zip, String filepath, String rootFolder) throws ZipException {
        ZipFile zipFile = new ZipFile(zip);
        ZipParameters parameters = new ZipParameters();
        parameters.setCompressionMethod(CompressionMethod.DEFLATE);
        parameters.setCompressionLevel(CompressionLevel.NORMAL);
        if (rootFolder == null) {
            rootFolder = "";
        }
        parameters.setRootFolderNameInZip(rootFolder);
        zipFile.addFile(filepath, parameters);
    }

    public static void deleteDexFromZip(String zipFilePath) throws ZipException {
        ZipFile zipFile = new ZipFile(zipFilePath);
        List files = zipFile.getFileHeaders();
        ArrayList<String> dexFiles = new ArrayList<String>();
        for (FileHeader file : files) {
            if (!file.getFileName().endsWith(".dex")) continue;
            dexFiles.add(file.getFileName());
        }
        zipFile.removeFiles(dexFiles);
    }
}

