/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.shaking;

import com.android.tools.r8.graph.AppInfoWithSubtyping;
import com.android.tools.r8.graph.DexClass;
import com.android.tools.r8.graph.DexEncodedMethod;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.shaking.ScopedDexMethodSet;
import java.util.ArrayList;

public class AbstractMethodRemover {
    private final AppInfoWithSubtyping appInfo;
    private ScopedDexMethodSet scope = new ScopedDexMethodSet();

    public AbstractMethodRemover(AppInfoWithSubtyping appInfo) {
        this.appInfo = appInfo;
    }

    public void run() {
        assert (this.scope.getParent() == null);
        this.processClass(this.appInfo.dexItemFactory.objectType);
    }

    private void processClass(DexType type) {
        DexClass holder = this.appInfo.definitionFor(type);
        this.scope = this.scope.newNestedScope();
        if (holder != null && !holder.isLibraryClass()) {
            holder.setVirtualMethods(this.processMethods(holder.virtualMethods()));
        }
        type.forAllExtendsSubtypes(this::processClass);
        this.scope = this.scope.getParent();
    }

    private DexEncodedMethod[] processMethods(DexEncodedMethod[] virtualMethods) {
        if (virtualMethods == null) {
            return null;
        }
        ArrayList<DexEncodedMethod> methods = null;
        for (int i = 0; i < virtualMethods.length; ++i) {
            DexEncodedMethod method = virtualMethods[i];
            if (this.scope.addMethod(method.method) || !method.accessFlags.isAbstract()) {
                if (methods == null) continue;
                methods.add(method);
                continue;
            }
            if (methods != null) continue;
            methods = new ArrayList<DexEncodedMethod>(virtualMethods.length - 1);
            for (int j = 0; j < i; ++j) {
                methods.add(virtualMethods[j]);
            }
        }
        return methods == null ? virtualMethods : methods.toArray(new DexEncodedMethod[methods.size()]);
    }
}

