/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.graph;

import com.android.tools.r8.graph.DexField;
import com.android.tools.r8.graph.DexMethod;
import com.android.tools.r8.graph.DexMethodHandle;
import com.android.tools.r8.graph.DexType;

public abstract class UseRegistry {
    public abstract boolean registerInvokeVirtual(DexMethod var1);

    public abstract boolean registerInvokeDirect(DexMethod var1);

    public abstract boolean registerInvokeStatic(DexMethod var1);

    public abstract boolean registerInvokeInterface(DexMethod var1);

    public abstract boolean registerInvokeSuper(DexMethod var1);

    public abstract boolean registerInstanceFieldWrite(DexField var1);

    public abstract boolean registerInstanceFieldRead(DexField var1);

    public abstract boolean registerNewInstance(DexType var1);

    public abstract boolean registerStaticFieldRead(DexField var1);

    public abstract boolean registerStaticFieldWrite(DexField var1);

    public abstract boolean registerTypeReference(DexType var1);

    public boolean registerConstClass(DexType type) {
        return this.registerTypeReference(type);
    }

    public boolean registerCheckCast(DexType type) {
        return this.registerTypeReference(type);
    }

    public void registerMethodHandle(DexMethodHandle methodHandle) {
        switch (methodHandle.type) {
            case INSTANCE_GET: {
                this.registerInstanceFieldRead(methodHandle.asField());
                break;
            }
            case INSTANCE_PUT: {
                this.registerInstanceFieldWrite(methodHandle.asField());
                break;
            }
            case STATIC_GET: {
                this.registerStaticFieldRead(methodHandle.asField());
                break;
            }
            case STATIC_PUT: {
                this.registerStaticFieldWrite(methodHandle.asField());
                break;
            }
            case INVOKE_INSTANCE: {
                this.registerInvokeVirtual(methodHandle.asMethod());
                break;
            }
            case INVOKE_STATIC: {
                this.registerInvokeStatic(methodHandle.asMethod());
                break;
            }
            case INVOKE_CONSTRUCTOR: {
                DexMethod method = methodHandle.asMethod();
                this.registerNewInstance(method.getHolder());
                this.registerInvokeDirect(method);
                break;
            }
            case INVOKE_INTERFACE: {
                this.registerInvokeInterface(methodHandle.asMethod());
                break;
            }
            case INVOKE_SUPER: {
                this.registerInvokeSuper(methodHandle.asMethod());
                break;
            }
            case INVOKE_DIRECT: {
                this.registerInvokeDirect(methodHandle.asMethod());
                break;
            }
            default: {
                throw new AssertionError();
            }
        }
    }
}

