/*
 * Decompiled with CFR 0.152.
 */
package brut.androlib.res.decoder;

import android.content.res.XmlResourceParser;
import android.util.TypedValue;
import brut.androlib.exceptions.AndrolibException;
import brut.androlib.res.data.ResID;
import brut.androlib.res.data.axml.NamespaceStack;
import brut.androlib.res.decoder.ResAttrDecoder;
import brut.androlib.res.decoder.StringBlock;
import brut.androlib.res.xml.ResXmlEncoders;
import brut.util.ExtDataInput;
import com.google.common.io.LittleEndianDataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.xmlpull.v1.XmlPullParserException;

public class AXmlResourceParser
implements XmlResourceParser {
    private ExtDataInput mIn;
    private ResAttrDecoder mAttrDecoder;
    private AndrolibException mFirstError;
    private boolean isOperational = false;
    private StringBlock mStringBlock;
    private int[] mResourceIds;
    private final NamespaceStack mNamespaces = new NamespaceStack();
    private boolean m_decreaseDepth;
    private int mEvent;
    private int mLineNumber;
    private int mNameIndex;
    private int mNamespaceIndex;
    private int[] mAttributes;
    private int mIdIndex;
    private int mClassIndex;
    private int mStyleIndex;
    private static final Logger LOGGER = Logger.getLogger(AXmlResourceParser.class.getName());

    public AXmlResourceParser() {
        this.resetEventInfo();
    }

    public AndrolibException getFirstError() {
        return this.mFirstError;
    }

    public ResAttrDecoder getAttrDecoder() {
        return this.mAttrDecoder;
    }

    public void setAttrDecoder(ResAttrDecoder attrDecoder) {
        this.mAttrDecoder = attrDecoder;
    }

    public void open(InputStream stream) {
        this.close();
        if (stream != null) {
            this.mIn = new ExtDataInput(new LittleEndianDataInputStream(stream));
        }
    }

    public void close() {
        if (!this.isOperational) {
            return;
        }
        this.isOperational = false;
        this.mIn = null;
        this.mStringBlock = null;
        this.mResourceIds = null;
        this.mNamespaces.reset();
        this.resetEventInfo();
    }

    public int next() throws XmlPullParserException, IOException {
        if (this.mIn == null) {
            throw new XmlPullParserException("Parser is not opened.", this, null);
        }
        try {
            this.doNext();
            return this.mEvent;
        }
        catch (IOException e) {
            this.close();
            throw e;
        }
    }

    @Override
    public int nextToken() throws XmlPullParserException, IOException {
        return this.next();
    }

    @Override
    public int getDepth() {
        return this.mNamespaces.getDepth() - 1;
    }

    @Override
    public int getEventType() {
        return this.mEvent;
    }

    @Override
    public int getLineNumber() {
        return this.mLineNumber;
    }

    @Override
    public String getName() {
        if (this.mNameIndex == -1 || this.mEvent != 2 && this.mEvent != 3) {
            return null;
        }
        return this.mStringBlock.getString(this.mNameIndex);
    }

    @Override
    public String getText() {
        if (this.mNameIndex == -1 || this.mEvent != 4) {
            return null;
        }
        return this.mStringBlock.getString(this.mNameIndex);
    }

    @Override
    public String getNamespace() {
        return this.mStringBlock.getString(this.mNamespaceIndex);
    }

    @Override
    public String getPositionDescription() {
        return "XML line #" + this.getLineNumber();
    }

    @Override
    public int getNamespaceCount(int depth) {
        return this.mNamespaces.getAccumulatedCount(depth);
    }

    @Override
    public String getNamespacePrefix(int pos) {
        int prefix = this.mNamespaces.getPrefix(pos);
        return this.mStringBlock.getString(prefix);
    }

    @Override
    public String getNamespaceUri(int pos) {
        int uri = this.mNamespaces.getUri(pos);
        return this.mStringBlock.getString(uri);
    }

    @Override
    public int getAttributeCount() {
        if (this.mEvent != 2) {
            return -1;
        }
        return this.mAttributes.length / 5;
    }

    @Override
    public String getAttributeNamespace(int index) {
        int offset = this.getAttributeOffset(index);
        int namespace = this.mAttributes[offset + 0];
        if (namespace == -1) {
            return "";
        }
        String value = this.mStringBlock.getString(namespace);
        if (value == null || value.length() == 0) {
            ResID resId = new ResID(this.getAttributeNameResource(index));
            value = resId.pkgId == 127 ? this.getNonDefaultNamespaceUri(offset) : "http://schemas.android.com/apk/res/android";
        }
        return value;
    }

    private String getNonDefaultNamespaceUri(int offset) {
        String prefix = this.mStringBlock.getString(this.mNamespaces.getPrefix(offset));
        if (prefix != null) {
            return this.mStringBlock.getString(this.mNamespaces.getUri(offset));
        }
        return "http://schemas.android.com/apk/res-auto";
    }

    public String getAttributePrefix(int index) {
        int offset = this.getAttributeOffset(index);
        int uri = this.mAttributes[offset + 0];
        int prefix = this.mNamespaces.findPrefix(uri);
        if (prefix == -1) {
            return "";
        }
        return this.mStringBlock.getString(prefix);
    }

    @Override
    public String getAttributeName(int index) {
        String resourceMapValue;
        int offset = this.getAttributeOffset(index);
        int name = this.mAttributes[offset + 1];
        if (name == -1) {
            return "";
        }
        String stringBlockValue = this.mStringBlock.getString(name);
        int resourceId = this.getAttributeNameResource(index);
        try {
            resourceMapValue = this.mAttrDecoder.decodeFromResourceId(resourceId);
        }
        catch (AndrolibException ignored) {
            resourceMapValue = null;
        }
        if (resourceMapValue != null) {
            return resourceMapValue;
        }
        if (stringBlockValue != null) {
            return stringBlockValue;
        }
        return "APKTOOL_MISSING_" + Integer.toHexString(resourceId);
    }

    public int getAttributeNameResource(int index) {
        int offset = this.getAttributeOffset(index);
        int name = this.mAttributes[offset + 1];
        if (this.mResourceIds == null || name < 0 || name >= this.mResourceIds.length) {
            return 0;
        }
        return this.mResourceIds[name];
    }

    public int getAttributeValueType(int index) {
        int offset = this.getAttributeOffset(index);
        return this.mAttributes[offset + 3];
    }

    @Override
    public String getAttributeValue(int index) {
        int offset = this.getAttributeOffset(index);
        int valueType = this.mAttributes[offset + 3];
        int valueData = this.mAttributes[offset + 4];
        int valueRaw = this.mAttributes[offset + 2];
        if (this.mAttrDecoder != null) {
            try {
                String stringBlockValue = valueRaw == -1 ? null : ResXmlEncoders.escapeXmlChars(this.mStringBlock.getString(valueRaw));
                String resourceMapValue = null;
                if (valueType == 1 || valueType == 7 || valueType == 2 || valueType == 8) {
                    resourceMapValue = this.mAttrDecoder.decodeFromResourceId(valueData);
                }
                String value = stringBlockValue;
                if (stringBlockValue != null && resourceMapValue != null) {
                    int slashPos = stringBlockValue.lastIndexOf("/");
                    int colonPos = stringBlockValue.lastIndexOf(":");
                    if (slashPos != -1) {
                        if (colonPos == -1) {
                            String type = stringBlockValue.substring(0, slashPos);
                            value = type + "/" + resourceMapValue;
                        }
                    } else if (!stringBlockValue.equals(resourceMapValue)) {
                        value = resourceMapValue;
                    }
                }
                return this.mAttrDecoder.decode(valueType, valueData, value, this.getAttributeNameResource(index));
            }
            catch (AndrolibException ex) {
                this.setFirstError(ex);
                LOGGER.log(Level.WARNING, String.format("Could not decode attr value, using undecoded value instead: ns=%s, name=%s, value=0x%08x", this.getAttributePrefix(index), this.getAttributeName(index), valueData), ex);
            }
        }
        return TypedValue.coerceToString(valueType, valueData);
    }

    @Override
    public void setInput(InputStream stream, String inputEncoding) {
        this.open(stream);
    }

    @Override
    public String getInputEncoding() {
        return null;
    }

    @Override
    public int getColumnNumber() {
        return -1;
    }

    @Override
    public Object getProperty(String name) {
        return null;
    }

    @Override
    public boolean getFeature(String feature) {
        return false;
    }

    private int getAttributeOffset(int index) {
        if (this.mEvent != 2) {
            throw new IndexOutOfBoundsException("Current event is not START_TAG.");
        }
        int offset = index * 5;
        if (offset >= this.mAttributes.length) {
            throw new IndexOutOfBoundsException("Invalid attribute index (" + index + ").");
        }
        return offset;
    }

    private void resetEventInfo() {
        this.mEvent = -1;
        this.mLineNumber = -1;
        this.mNameIndex = -1;
        this.mNamespaceIndex = -1;
        this.mAttributes = null;
        this.mIdIndex = -1;
        this.mClassIndex = -1;
        this.mStyleIndex = -1;
    }

    private void doNext() throws IOException {
        block17: {
            if (this.mStringBlock == null) {
                this.mIn.skipInt();
                this.mIn.skipInt();
                this.mStringBlock = StringBlock.readWithChunk(this.mIn);
                this.mNamespaces.increaseDepth();
                this.isOperational = true;
            }
            if (this.mEvent == 1) {
                return;
            }
            int event = this.mEvent;
            this.resetEventInfo();
            while (true) {
                int chunkType;
                if (this.m_decreaseDepth) {
                    this.m_decreaseDepth = false;
                    this.mNamespaces.decreaseDepth();
                }
                if (event == 3 && this.mNamespaces.getDepth() == 1 && this.mNamespaces.getCurrentCount() == 0) {
                    this.mEvent = 1;
                    break block17;
                }
                if (event == 0) {
                    chunkType = 258;
                } else {
                    chunkType = this.mIn.readShort();
                    this.mIn.skipShort();
                }
                if (chunkType == 384) {
                    int chunkSize = this.mIn.readInt();
                    if (chunkSize < 8 || chunkSize % 4 != 0) {
                        throw new IOException("Invalid resource ids size (" + chunkSize + ").");
                    }
                    this.mResourceIds = this.mIn.readIntArray(chunkSize / 4 - 2);
                    continue;
                }
                if (chunkType < 256 || chunkType > 383) {
                    throw new IOException("Invalid chunk type (" + chunkType + ").");
                }
                if (chunkType == 258 && event == -1) {
                    this.mEvent = 0;
                    break block17;
                }
                this.mIn.skipInt();
                this.mLineNumber = this.mIn.readInt();
                this.mIn.skipInt();
                if (chunkType == 256 || chunkType == 257) {
                    if (chunkType == 256) {
                        int prefix = this.mIn.readInt();
                        int uri = this.mIn.readInt();
                        this.mNamespaces.push(prefix, uri);
                        continue;
                    }
                    this.mIn.skipInt();
                    this.mIn.skipInt();
                    this.mNamespaces.pop();
                    continue;
                }
                if (chunkType == 258) {
                    this.mNamespaceIndex = this.mIn.readInt();
                    this.mNameIndex = this.mIn.readInt();
                    this.mIn.skipShort();
                    short attributeSize = this.mIn.readShort();
                    short attributeCount = this.mIn.readShort();
                    this.mIdIndex = this.mIn.readShort();
                    this.mClassIndex = this.mIn.readShort();
                    this.mStyleIndex = this.mIn.readShort();
                    this.mAttributes = this.mIn.readIntArray(attributeCount * 5);
                    for (int i = 3; i < this.mAttributes.length; i += 5) {
                        this.mAttributes[i] = this.mAttributes[i] >>> 24;
                    }
                    int byteAttrSizeRead = attributeCount * 5 * 4;
                    int byteAttrSizeReported = attributeSize * attributeCount;
                    if (byteAttrSizeRead < byteAttrSizeReported) {
                        int bytesToSkip = byteAttrSizeReported - byteAttrSizeRead;
                        this.mIn.skipBytes(bytesToSkip);
                        LOGGER.fine("Skipping " + bytesToSkip + " unknown bytes in attributes area.");
                    }
                    this.mNamespaces.increaseDepth();
                    this.mEvent = 2;
                    break block17;
                }
                if (chunkType == 259) {
                    this.mNamespaceIndex = this.mIn.readInt();
                    this.mNameIndex = this.mIn.readInt();
                    this.mEvent = 3;
                    this.m_decreaseDepth = true;
                    break block17;
                }
                if (chunkType == 260) break;
            }
            this.mNameIndex = this.mIn.readInt();
            this.mIn.skipInt();
            this.mIn.skipInt();
            this.mEvent = 4;
        }
    }

    private void setFirstError(AndrolibException error) {
        if (this.mFirstError == null) {
            this.mFirstError = error;
        }
    }
}

