/*
 * Decompiled with CFR 0.152.
 */
package org.conscrypt;

import java.security.GeneralSecurityException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import org.conscrypt.HpkeContext;
import org.conscrypt.HpkeSpi;

public class HpkeContextRecipient
extends HpkeContext {
    private HpkeContextRecipient(HpkeSpi spi) {
        super(spi);
    }

    public byte[] open(byte[] ciphertext, byte[] aad) throws GeneralSecurityException {
        return this.spi.engineOpen(ciphertext, aad);
    }

    public static HpkeContextRecipient getInstance(String suite) throws NoSuchAlgorithmException {
        return new HpkeContextRecipient(HpkeContextRecipient.findSpi(suite));
    }

    public static HpkeContextRecipient getInstance(String suite, String providerName) throws NoSuchAlgorithmException, NoSuchProviderException {
        return new HpkeContextRecipient(HpkeContextRecipient.findSpi(suite, providerName));
    }

    public static HpkeContextRecipient getInstance(String suite, Provider provider) throws NoSuchAlgorithmException, NoSuchProviderException {
        return new HpkeContextRecipient(HpkeContextRecipient.findSpi(suite, provider));
    }

    public void init(byte[] encapsulated, PrivateKey recipientKey, byte[] info) throws InvalidKeyException {
        this.spi.engineInitRecipient(encapsulated, recipientKey, info, null, HpkeSpi.DEFAULT_PSK, HpkeSpi.DEFAULT_PSK_ID);
    }

    public void init(byte[] encapsulated, PrivateKey recipientKey, byte[] info, PublicKey senderKey) throws InvalidKeyException {
        if (senderKey == null) {
            throw new InvalidKeyException("null sender key");
        }
        this.spi.engineInitRecipient(encapsulated, recipientKey, info, senderKey, HpkeSpi.DEFAULT_PSK, HpkeSpi.DEFAULT_PSK_ID);
    }

    public void init(byte[] encapsulated, PrivateKey recipientKey, byte[] info, byte[] psk, byte[] psk_id) throws InvalidKeyException {
        this.spi.engineInitRecipient(encapsulated, recipientKey, info, null, psk, psk_id);
    }

    public void init(byte[] encapsulated, PrivateKey recipientKey, byte[] info, PublicKey senderKey, byte[] psk, byte[] psk_id) throws InvalidKeyException {
        if (senderKey == null) {
            throw new InvalidKeyException("null sender key");
        }
        this.spi.engineInitRecipient(encapsulated, recipientKey, info, senderKey, psk, psk_id);
    }
}

