/*
 * Decompiled with CFR 0.152.
 */
package org.conscrypt;

import java.util.Arrays;

public final class ArrayUtils {
    private ArrayUtils() {
    }

    public static void checkOffsetAndCount(int arrayLength, int offset, int count) {
        if ((offset | count) < 0 || offset > arrayLength || arrayLength - offset < count) {
            throw new ArrayIndexOutOfBoundsException("length=" + arrayLength + "; regionStart=" + offset + "; regionLength=" + count);
        }
    }

    @SafeVarargs
    public static <T> T[] concatValues(T[] a1, T ... values) {
        return ArrayUtils.concat(a1, values);
    }

    public static <T> T[] concat(T[] a1, T[] a2) {
        T[] result = Arrays.copyOf(a1, a1.length + a2.length);
        System.arraycopy(a2, 0, result, a1.length, a2.length);
        return result;
    }

    public static byte[] concat(byte[] a1, byte[] a2) {
        byte[] result = Arrays.copyOf(a1, a1.length + a2.length);
        System.arraycopy(a2, 0, result, a1.length, a2.length);
        return result;
    }

    public static boolean startsWith(byte[] array, byte[] startsWith) {
        if (array.length < startsWith.length) {
            return false;
        }
        for (int i = 0; i < startsWith.length; ++i) {
            if (array[i] == startsWith[i]) continue;
            return false;
        }
        return true;
    }

    public static byte[] reverse(byte[] array) {
        byte[] result = new byte[array.length];
        int front = 0;
        int back = array.length - 1;
        while (back >= 0) {
            result[front++] = array[back--];
        }
        return result;
    }

    public static <T> boolean isEmpty(T[] array) {
        return array == null || array.length == 0;
    }
}

