/*
 * Decompiled with CFR 0.152.
 */
package com.frezrik.jiagu.pack.util.axml.meditor.utils;

import com.frezrik.jiagu.pack.util.axml.meditor.utils.Utils;
import java.io.FileInputStream;
import java.util.HashMap;

public class FileTypeUtils {
    private static final HashMap<String, String> fileHeaderCache = new HashMap();

    public static boolean isAndroidManifestFile(String filePath) {
        String sufix = filePath.substring(filePath.lastIndexOf(".") + 1);
        if ("xml".equalsIgnoreCase(sufix)) {
            return true;
        }
        String fileHeader = FileTypeUtils.getFileHeader(filePath);
        return "03000800".equalsIgnoreCase(fileHeader);
    }

    public static boolean isApkFile(String filePath) {
        String sufix = filePath.substring(filePath.lastIndexOf(".") + 1);
        if ("apk".equalsIgnoreCase(sufix)) {
            return true;
        }
        String fileHeader = FileTypeUtils.getFileHeader(filePath);
        return "504B0304".equalsIgnoreCase(fileHeader);
    }

    public static String getFileHeader(String filePath) {
        String cachedHeader = fileHeaderCache.get(filePath);
        if (cachedHeader != null && !cachedHeader.isEmpty()) {
            return cachedHeader;
        }
        String header = FileTypeUtils.getFileHeaderInternal(filePath);
        fileHeaderCache.put(filePath, header);
        return header;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getFileHeaderInternal(String filePath) {
        FileInputStream is = null;
        String value = null;
        try {
            is = new FileInputStream(filePath);
            byte[] b = new byte[4];
            is.read(b, 0, b.length);
            value = FileTypeUtils.bytesToHexString(b);
        }
        catch (Exception exception) {
            Utils.close(is);
        }
        catch (Throwable throwable) {
            Utils.close(is);
            throw throwable;
        }
        Utils.close(is);
        return value;
    }

    private static String bytesToHexString(byte[] src) {
        StringBuilder builder = new StringBuilder();
        if (src == null || src.length <= 0) {
            return null;
        }
        for (int i = 0; i < src.length; ++i) {
            String hv = Integer.toHexString(src[i] & 0xFF).toUpperCase();
            if (hv.length() < 2) {
                builder.append(0);
            }
            builder.append(hv);
        }
        return builder.toString();
    }
}

