/*
 * Decompiled with CFR 0.152.
 */
package com.frezrik.jiagu.pack;

import com.frezrik.jiagu.pack.core.AppManager;
import com.frezrik.jiagu.pack.core.Log;
import com.frezrik.jiagu.pack.util.AXmlUtil;
import com.frezrik.jiagu.pack.util.DexUtils;
import com.frezrik.jiagu.pack.util.EncryptUtils;
import com.frezrik.jiagu.pack.util.FileUtils;
import com.frezrik.jiagu.pack.util.SignUtils;
import com.frezrik.jiagu.pack.util.ZipUtil;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public class Main {
    private static String key;
    private static String keyPwd;
    private static String alias;
    private static String aliasPwd;
    private static String keylevel;
    private static String OUT_TMP;

    private static String parse(String[] args) {
        String opt;
        String apk = "";
        int opti = 0;
        while (opti < args.length && (opt = args[opti]) != null && opt.length() > 0 && opt.charAt(0) == '-') {
            ++opti;
            if ("-apk".equals(opt)) {
                if (opti < args.length) {
                    apk = args[opti];
                    ++opti;
                    continue;
                }
                Log.d("Error: -apk option requires apk argument");
                return null;
            }
            if ("-key".equals(opt)) {
                if (opti < args.length) {
                    key = args[opti];
                    ++opti;
                    continue;
                }
                Log.d("Error: -key option requires keystore argument");
                return null;
            }
            if ("-kp".equals(opt)) {
                if (opti < args.length) {
                    keyPwd = args[opti];
                    ++opti;
                    continue;
                }
                Log.d("Error: -kp option requires keystore password argument");
                return null;
            }
            if ("-alias".equals(opt)) {
                if (opti < args.length) {
                    alias = args[opti];
                    ++opti;
                    continue;
                }
                Log.d("Error: -alias option requires keystore alias argument");
                return null;
            }
            if ("-ap".equals(opt)) {
                if (opti < args.length) {
                    aliasPwd = args[opti];
                    ++opti;
                    continue;
                }
                Log.d("Error: -ap option requires keystore alias password argument");
                return null;
            }
            if (!"-keylevel".equals(opt)) continue;
            if (opti < args.length) {
                keylevel = args[opti];
                ++opti;
                continue;
            }
            Log.d("Error: -keylevel option requires v2,v3,v1v2v3");
            return null;
        }
        return apk;
    }

    public static void main(String[] args) {
        File shellDex;
        String apk = Main.parse(args);
        File apkFile = new File(apk);
        Log.d("\u6b63\u5728\u52a0\u56fa\uff1a" + apkFile.getAbsolutePath());
        File outputDir = new File(AppManager.OUT_DIR);
        String substring = apkFile.getName().substring(0, apkFile.getName().lastIndexOf("."));
        File apkUnzipDir = new File(AppManager.TEMP_UNZIP_APK + substring + "/");
        if (!apkUnzipDir.exists()) {
            apkUnzipDir.mkdirs();
        }
        List<String> rawPathList = ZipUtil.unZip(apkFile, apkUnzipDir);
        FileUtils.delete("/META-INF/CERT.RSA");
        FileUtils.delete("/META-INF/CERT.SF");
        FileUtils.delete("/META-INF/MANIFEST.MF");
        String applicationName = AXmlUtil.updateManifest(AppManager.TEMP_MANI + substring + "/AndroidManifest.xml");
        File shellFile = new File("jiagu/build/outputs/aar/jiagu-release.aar");
        if (shellFile.exists()) {
            if (!apkFile.exists() || !shellFile.exists()) {
                Log.d("apkFile or shellFile missing");
                return;
            }
            Log.d("\u89e3\u538b\u58f3AAR");
            File shellUnzipDir = new File(AppManager.TEMP_SHELL + "/" + substring + "/shell");
            if (!shellUnzipDir.exists()) {
                shellUnzipDir.mkdirs();
            }
            ZipUtil.unZip(shellFile, shellUnzipDir);
            Log.d("\u5c06jar\u8f6c\u6210dex");
            File shellJar = new File(shellUnzipDir, "classes.jar");
            shellDex = new File(shellUnzipDir, "classes.dex");
            try {
                DexUtils.dxCommand(shellJar, shellDex);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            shellDex = new File(AppManager.DEX_PATH);
        }
        File[] dexFiles = apkUnzipDir.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File file, String s) {
                return s.endsWith(".dex");
            }
        });
        Collections.sort(Arrays.asList(dexFiles), new Comparator<File>(){

            @Override
            public int compare(File o1, File o2) {
                if (o1.getName().length() < o2.getName().length()) {
                    return -1;
                }
                return o1.getName().compareTo(o2.getName());
            }
        });
        byte[] shelldex = new byte[]{};
        try {
            shelldex = FileUtils.readFileBytes(shellDex);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        byte[] tempDex = new byte[1 + applicationName.length()];
        tempDex[0] = (byte)applicationName.length();
        System.arraycopy(applicationName.getBytes(), 0, tempDex, 1, tempDex[0]);
        byte[] encryptData = null;
        for (int i = 0; i < dexFiles.length; ++i) {
            File file = dexFiles[i];
            try {
                byte[] oridex = FileUtils.readFileBytes(file);
                Log.d("\u52a0\u5bc6dex:" + file.getPath() + " " + oridex.length);
                if (i == 0) {
                    tempDex = Arrays.copyOf(tempDex, tempDex.length + 4 + oridex.length);
                    System.arraycopy(DexUtils.intToByte(oridex.length), 0, tempDex, tempDex.length - 4 - oridex.length, 4);
                    System.arraycopy(oridex, 0, tempDex, tempDex.length - oridex.length, oridex.length);
                    encryptData = EncryptUtils.encrypt(tempDex, 512);
                } else {
                    encryptData = Arrays.copyOf(encryptData, encryptData.length + 4 + oridex.length);
                    System.arraycopy(DexUtils.intToByte(oridex.length), 0, encryptData, encryptData.length - 4 - oridex.length, 4);
                    tempDex = EncryptUtils.encryptXor(oridex);
                    System.arraycopy(tempDex, 0, encryptData, encryptData.length - oridex.length, oridex.length);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            file.delete();
        }
        try {
            DexUtils.mergeDex(dexFiles[0].getAbsolutePath(), shelldex, encryptData);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        File assetsDir = new File(apkUnzipDir, "assets");
        if (!assetsDir.exists()) {
            assetsDir.mkdirs();
        }
        String so_path = new File(AppManager.TEST_SO).exists() ? AppManager.TEST_SO : AppManager.SO_PATH;
        File so = new File(so_path + "armeabi-v7a/libjiagu.so");
        File so_64 = new File(so_path + "arm64-v8a/libjiagu.so");
        File so_x86 = new File(so_path + "x86/libjiagu.so");
        File so_x86_64 = new File(so_path + "x86_64/libjiagu.so");
        FileUtils.copy(so, new File(assetsDir, "libjiagu.so"));
        FileUtils.copy(so_64, new File(assetsDir, "libjiagu_64.so"));
        FileUtils.copy(so_x86, new File(assetsDir, "libjiagu_x86.so"));
        FileUtils.copy(so_x86_64, new File(assetsDir, "libjiagu_x86_64.so"));
        Log.d("\u6253\u5305APK");
        File unsignedApk = new File(AppManager.RUNTIME_PATH + "output/" + apkFile.getName().substring(0, apkFile.getName().length() - 4) + "_unsigned.apk");
        try {
            ZipUtil.zip(apkUnzipDir, unsignedApk, rawPathList);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (!new File(AppManager.TEMP_SHELL + "/" + substring + "/shell").exists()) {
            FileUtils.delete(AppManager.TEMP_UNZIP + substring + "/");
        }
        Log.d("\u7b7e\u540dAPK");
        File signedApk = new File(AppManager.OUT_DIR + apkFile.getName().substring(0, apkFile.getName().length() - 4) + "_signed.apk");
        if ("v2".equals(keylevel)) {
            try {
                SignUtils.apkSignatureV2(unsignedApk, signedApk, key, keyPwd, alias, aliasPwd);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else if ("v3".equals(keylevel)) {
            try {
                SignUtils.apkSignatureV3(unsignedApk, signedApk, key, keyPwd, alias, aliasPwd);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else if ("v2v3".equals(keylevel)) {
            try {
                SignUtils.apkSignatureV2V3(unsignedApk, signedApk, key, keyPwd, alias, aliasPwd);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            try {
                SignUtils.apkSignature(unsignedApk, signedApk, key, keyPwd, alias, aliasPwd);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        Log.d("Finished!!!");
    }

    static {
        OUT_TMP = "temp/";
    }
}

