/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.io;

import com.google.common.io.ByteStreams;
import com.google.common.io.CountingInputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.FilterInputStream;

public final class LittleEndianDataInputStream
extends FilterInputStream
implements DataInput {
    public LittleEndianDataInputStream(CountingInputStream countingInputStream) {
        super(countingInputStream);
    }

    @Override
    public final String readLine() {
        throw new UnsupportedOperationException("readLine is not supported");
    }

    @Override
    public final void readFully(byte[] byArray) {
        int n = byArray.length;
        ByteStreams.readFully(this, byArray, 0, n);
    }

    @Override
    public final void readFully(byte[] byArray, int n, int n2) {
        ByteStreams.readFully(this, byArray, n, n2);
    }

    @Override
    public final int skipBytes(int n) {
        return (int)this.in.skip(n);
    }

    @Override
    public final int readUnsignedByte() {
        int n = this.in.read();
        if (n >= 0) {
            return n;
        }
        throw new EOFException();
    }

    @Override
    public final int readUnsignedShort() {
        LittleEndianDataInputStream littleEndianDataInputStream = this;
        byte by = littleEndianDataInputStream.readAndCheckByte();
        return (littleEndianDataInputStream.readAndCheckByte() & 0xFF) << 8 | by & 0xFF;
    }

    @Override
    public final int readInt() {
        LittleEndianDataInputStream littleEndianDataInputStream = this;
        byte by = littleEndianDataInputStream.readAndCheckByte();
        byte by2 = littleEndianDataInputStream.readAndCheckByte();
        byte by3 = littleEndianDataInputStream.readAndCheckByte();
        return littleEndianDataInputStream.readAndCheckByte() << 24 | (by3 & 0xFF) << 16 | (by2 & 0xFF) << 8 | by & 0xFF;
    }

    @Override
    public final long readLong() {
        LittleEndianDataInputStream littleEndianDataInputStream = this;
        byte by = littleEndianDataInputStream.readAndCheckByte();
        byte by2 = littleEndianDataInputStream.readAndCheckByte();
        byte by3 = littleEndianDataInputStream.readAndCheckByte();
        byte by4 = littleEndianDataInputStream.readAndCheckByte();
        byte by5 = littleEndianDataInputStream.readAndCheckByte();
        byte by6 = littleEndianDataInputStream.readAndCheckByte();
        byte by7 = littleEndianDataInputStream.readAndCheckByte();
        return ((long)littleEndianDataInputStream.readAndCheckByte() & 0xFFL) << 56 | ((long)by7 & 0xFFL) << 48 | ((long)by6 & 0xFFL) << 40 | ((long)by5 & 0xFFL) << 32 | ((long)by4 & 0xFFL) << 24 | ((long)by3 & 0xFFL) << 16 | ((long)by2 & 0xFFL) << 8 | (long)by & 0xFFL;
    }

    @Override
    public final float readFloat() {
        return Float.intBitsToFloat(this.readInt());
    }

    @Override
    public final double readDouble() {
        return Double.longBitsToDouble(this.readLong());
    }

    @Override
    public final String readUTF() {
        return new DataInputStream(this.in).readUTF();
    }

    @Override
    public final short readShort() {
        return (short)this.readUnsignedShort();
    }

    @Override
    public final char readChar() {
        return (char)this.readUnsignedShort();
    }

    @Override
    public final byte readByte() {
        return (byte)this.readUnsignedByte();
    }

    @Override
    public final boolean readBoolean() {
        return this.readUnsignedByte() != 0;
    }

    public final byte readAndCheckByte() {
        int n = this.in.read();
        if (-1 != n) {
            return (byte)n;
        }
        throw new EOFException();
    }
}

