/*
 * Decompiled with CFR 0.152.
 */
package brut.util;

import brut.common.BrutException;
import brut.util.Jar;
import brut.util.OS;
import brut.util.OSDetection;
import java.io.File;
import java.util.ArrayList;

public abstract class AaptManager {
    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static File getAaptBinary(int n) {
        StringBuilder stringBuilder;
        CharSequence charSequence;
        Object object = n != 2 ? "aapt" : "aapt2";
        if (!OSDetection.is64Bit() && ((String)(charSequence = OSDetection.OS)).contains("mac")) {
            throw new BrutException((String)object + " binary is not available for 32-bit platform: " + (String)charSequence);
        }
        charSequence = stringBuilder;
        stringBuilder = new StringBuilder("/prebuilt/");
        String string = OSDetection.OS;
        if (!(string.contains("nix") || string.contains("nux") || string.contains("aix") || string.contains("sunos"))) {
            if (string.contains("mac")) {
                ((StringBuilder)charSequence).append("macosx");
            } else {
                if (!string.contains("win")) throw new BrutException("Could not identify platform: ".concat(string));
                ((StringBuilder)charSequence).append("windows");
            }
        } else {
            ((StringBuilder)charSequence).append("linux");
        }
        ((StringBuilder)charSequence).append("/");
        ((StringBuilder)charSequence).append((String)object);
        if (OSDetection.is64Bit()) {
            ((StringBuilder)charSequence).append("_64");
        }
        if (string.contains("win")) {
            ((StringBuilder)charSequence).append(".exe");
        }
        if (!((File)(object = Jar.getResourceAsFile(((StringBuilder)charSequence).toString()))).isFile() || !((File)object).canRead()) throw new BrutException("Could not read aapt binary: " + ((File)object).getPath());
        if (!((File)object).setExecutable(true)) throw new BrutException("Could not set aapt binary as executable: " + ((File)object).getPath());
        return object;
    }

    /*
     * Enabled aggressive block sorting
     */
    public static int getAaptVersion(File file) {
        if (!file.isFile()) throw new BrutException("Could not read aapt binary: " + file.getPath());
        if (!file.canRead()) throw new BrutException("Could not read aapt binary: " + file.getPath());
        if (!file.setExecutable(true)) throw new BrutException("Could not set aapt binary as executable: " + file.getPath());
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(file.getPath());
        arrayList.add("version");
        String string = OS.execAndReturn(arrayList.toArray(new String[0]));
        if (string == null) throw new BrutException("Could not execute aapt binary at location: " + file.getPath());
        if (string.startsWith("Android Asset Packaging Tool (aapt) 2:")) return 2;
        if (string.startsWith("Android Asset Packaging Tool (aapt) 2.")) return 2;
        if (!string.startsWith("Android Asset Packaging Tool, v0.")) throw new BrutException("aapt version could not be identified: ".concat(string));
        return 1;
    }
}

