/*
 * Decompiled with CFR 0.152.
 */
package com.apktoolscnm.apktoolcnm.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PngValidator {
    private static final Logger logger = LoggerFactory.getLogger(PngValidator.class);

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean isValidPng(File file) {
        if (file == null) return false;
        if (!file.exists()) {
            return false;
        }
        try (FileInputStream fis = new FileInputStream(file);){
            byte[] header = new byte[8];
            int bytesRead = fis.read(header);
            if (bytesRead != 8) {
                logger.warn("\u6587\u4ef6\u5934\u8bfb\u53d6\u4e0d\u5b8c\u6574: {}", (Object)file.getAbsolutePath());
                boolean bl = false;
                return bl;
            }
            if (header[0] == -119 && header[1] == 80 && header[2] == 78 && header[3] == 71 && header[4] == 13 && header[5] == 10 && header[6] == 26 && header[7] == 10) {
                logger.debug("\u6587\u4ef6\u662f\u6709\u6548\u7684PNG\u683c\u5f0f: {}", (Object)file.getAbsolutePath());
                boolean bl = true;
                return bl;
            }
            logger.warn("\u6587\u4ef6\u4e0d\u662f\u6709\u6548\u7684PNG\u683c\u5f0f: {}", (Object)file.getAbsolutePath());
            boolean bl = false;
            return bl;
        }
        catch (IOException e) {
            logger.error("\u9a8c\u8bc1PNG\u6587\u4ef6\u5931\u8d25: {}", (Object)file.getAbsolutePath(), (Object)e);
            return false;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String getFileHeader(File file) {
        if (file == null) return "\u6587\u4ef6\u4e0d\u5b58\u5728";
        if (!file.exists()) {
            return "\u6587\u4ef6\u4e0d\u5b58\u5728";
        }
        try (FileInputStream fis = new FileInputStream(file);){
            byte[] header = new byte[8];
            int bytesRead = fis.read(header);
            if (bytesRead != 8) {
                String string = String.format("\u6587\u4ef6\u5934\u8bfb\u53d6\u4e0d\u5b8c\u6574\uff0c\u53ea\u8bfb\u53d6\u4e86 %d \u5b57\u8282", bytesRead);
                return string;
            }
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < 8; ++i) {
                sb.append(String.format("%02X ", header[i]));
            }
            String string = sb.toString().trim();
            return string;
        }
        catch (IOException e) {
            return "\u8bfb\u53d6\u6587\u4ef6\u5934\u5931\u8d25: " + e.getMessage();
        }
    }
}

