/*
 * Decompiled with CFR 0.152.
 */
package com.apktoolscnm.apktoolcnm.util;

import com.apktoolscnm.apktoolcnm.util.PngValidator;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import javax.imageio.ImageIO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public class ImageConverter {
    private static final Logger logger = LoggerFactory.getLogger(ImageConverter.class);

    public static boolean convertToPng(File sourceFile, File targetFile) {
        if (sourceFile == null || !sourceFile.exists()) {
            logger.error("\u6e90\u6587\u4ef6\u4e0d\u5b58\u5728: {}", (Object)(sourceFile != null ? sourceFile.getAbsolutePath() : "null"));
            return false;
        }
        try {
            BufferedImage sourceImage = ImageIO.read(sourceFile);
            if (sourceImage == null) {
                logger.error("\u65e0\u6cd5\u8bfb\u53d6\u56fe\u7247\u6587\u4ef6: {}", (Object)sourceFile.getAbsolutePath());
                return false;
            }
            logger.info("\u6210\u529f\u8bfb\u53d6\u56fe\u7247: {} (\u5c3a\u5bf8: {}x{})", new Object[]{sourceFile.getAbsolutePath(), sourceImage.getWidth(), sourceImage.getHeight()});
            File targetDir = targetFile.getParentFile();
            if (!targetDir.exists() && !targetDir.mkdirs()) {
                logger.error("\u65e0\u6cd5\u521b\u5efa\u76ee\u6807\u76ee\u5f55: {}", (Object)targetDir.getAbsolutePath());
                return false;
            }
            boolean success = ImageIO.write((RenderedImage)sourceImage, "PNG", targetFile);
            if (success) {
                logger.info("\u56fe\u7247\u8f6c\u6362\u6210\u529f: {} -> {}", (Object)sourceFile.getName(), (Object)targetFile.getAbsolutePath());
                if (PngValidator.isValidPng((File)targetFile)) {
                    logger.info("\u8f6c\u6362\u540e\u7684PNG\u6587\u4ef6\u9a8c\u8bc1\u901a\u8fc7");
                    return true;
                }
                logger.warn("\u8f6c\u6362\u540e\u7684\u6587\u4ef6\u4e0d\u662f\u6709\u6548\u7684PNG\u683c\u5f0f");
                return false;
            }
            logger.error("\u56fe\u7247\u8f6c\u6362\u5931\u8d25: {}", (Object)sourceFile.getAbsolutePath());
            return false;
        }
        catch (IOException e) {
            logger.error("\u56fe\u7247\u8f6c\u6362\u8fc7\u7a0b\u4e2d\u53d1\u751f\u9519\u8bef: {}", (Object)sourceFile.getAbsolutePath(), (Object)e);
            return false;
        }
    }

    public static boolean convertToPngWithResize(File sourceFile, File targetFile, int targetSize) {
        if (sourceFile == null || !sourceFile.exists()) {
            logger.error("\u6e90\u6587\u4ef6\u4e0d\u5b58\u5728: {}", (Object)(sourceFile != null ? sourceFile.getAbsolutePath() : "null"));
            return false;
        }
        try {
            BufferedImage sourceImage = ImageIO.read(sourceFile);
            if (sourceImage == null) {
                logger.error("\u65e0\u6cd5\u8bfb\u53d6\u56fe\u7247\u6587\u4ef6: {}", (Object)sourceFile.getAbsolutePath());
                return false;
            }
            logger.info("\u6210\u529f\u8bfb\u53d6\u56fe\u7247: {} (\u539f\u59cb\u5c3a\u5bf8: {}x{})", new Object[]{sourceFile.getAbsolutePath(), sourceImage.getWidth(), sourceImage.getHeight()});
            File targetDir = targetFile.getParentFile();
            if (!targetDir.exists() && !targetDir.mkdirs()) {
                logger.error("\u65e0\u6cd5\u521b\u5efa\u76ee\u6807\u76ee\u5f55: {}", (Object)targetDir.getAbsolutePath());
                return false;
            }
            BufferedImage resizedImage = ImageConverter.resizeImage((BufferedImage)sourceImage, (int)targetSize, (int)targetSize);
            boolean success = ImageIO.write((RenderedImage)resizedImage, "PNG", targetFile);
            if (success) {
                logger.info("\u56fe\u7247\u8f6c\u6362\u5e76\u8c03\u6574\u5c3a\u5bf8\u6210\u529f: {} -> {} (\u5c3a\u5bf8: {}x{})", new Object[]{sourceFile.getName(), targetFile.getAbsolutePath(), targetSize, targetSize});
                if (PngValidator.isValidPng((File)targetFile)) {
                    logger.info("\u8f6c\u6362\u540e\u7684PNG\u6587\u4ef6\u9a8c\u8bc1\u901a\u8fc7");
                    return true;
                }
                logger.warn("\u8f6c\u6362\u540e\u7684\u6587\u4ef6\u4e0d\u662f\u6709\u6548\u7684PNG\u683c\u5f0f");
                return false;
            }
            logger.error("\u56fe\u7247\u8f6c\u6362\u5931\u8d25: {}", (Object)sourceFile.getAbsolutePath());
            return false;
        }
        catch (IOException e) {
            logger.error("\u56fe\u7247\u8f6c\u6362\u8fc7\u7a0b\u4e2d\u53d1\u751f\u9519\u8bef: {}", (Object)sourceFile.getAbsolutePath(), (Object)e);
            return false;
        }
    }

    private static BufferedImage resizeImage(BufferedImage sourceImage, int targetWidth, int targetHeight) {
        BufferedImage resizedImage = new BufferedImage(targetWidth, targetHeight, 2);
        Graphics2D g2d = resizedImage.createGraphics();
        g2d.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
        g2d.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2d.drawImage(sourceImage, 0, 0, targetWidth, targetHeight, null);
        g2d.dispose();
        return resizedImage;
    }

    public static boolean isSupportedImageFormat(File file) {
        if (file == null || !file.exists()) {
            return false;
        }
        String fileName = file.getName().toLowerCase();
        return fileName.endsWith(".png") || fileName.endsWith(".jpg") || fileName.endsWith(".jpeg") || fileName.endsWith(".gif") || fileName.endsWith(".bmp") || fileName.endsWith(".webp");
    }

    public static String[] getSupportedFormats() {
        return ImageIO.getReaderFormatNames();
    }
}

