/*
 * Decompiled with CFR 0.152.
 */
package com.apktoolscnm.apktoolcnm.util;

import java.io.File;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class DebugKeyGenerator {
    private static final Logger logger = LoggerFactory.getLogger(DebugKeyGenerator.class);
    @Value(value="${android.debug.keystore.path:${user.home}/.android/debug.keystore}")
    private String keystorePath;
    private static final String KEYSTORE_TYPE = "JKS";
    private static final String KEY_ALGORITHM = "RSA";
    private static final int KEY_SIZE = 2048;
    private static final int VALIDITY_DAYS = 10000;
    private static final String KEYSTORE_PASSWORD = "android";
    private static final String KEY_PASSWORD = "android";

    public void ensureDebugKeyExists() {
        File keystoreFile = new File(this.keystorePath);
        if (keystoreFile.exists()) {
            logger.info("\u4f7f\u7528\u73b0\u6709\u7684 debug.keystore: {}", (Object)this.keystorePath);
            return;
        }
        try {
            logger.info("\u5f00\u59cb\u751f\u6210 debug.keystore: {}", (Object)this.keystorePath);
            Files.createDirectories(keystoreFile.getParentFile().toPath(), new FileAttribute[0]);
            logger.info("\u521b\u5efa\u5bc6\u94a5\u5e93\u76ee\u5f55: {}", (Object)keystoreFile.getParentFile().getAbsolutePath());
            ProcessBuilder pb = new ProcessBuilder("keytool", "-genkey", "-v", "-keystore", this.keystorePath, "-storepass", "android", "-alias", "androiddebugkey", "-keypass", "android", "-keyalg", KEY_ALGORITHM, "-keysize", String.valueOf(2048), "-validity", String.valueOf(10000), "-dname", "CN=Android Debug,O=Android,C=US");
            Process process = pb.start();
            boolean finished = process.waitFor(60L, TimeUnit.SECONDS);
            if (!finished) {
                process.destroyForcibly();
                throw new RuntimeException("\u751f\u6210 debug.keystore \u8d85\u65f6");
            }
            int exitCode = process.waitFor();
            if (exitCode != 0) {
                throw new RuntimeException("\u751f\u6210 debug.keystore \u5931\u8d25\uff0c\u9000\u51fa\u7801: " + exitCode);
            }
            logger.info("\u6210\u529f\u751f\u6210 debug.keystore: {}", (Object)this.keystorePath);
            keystoreFile.setReadable(true, false);
            keystoreFile.setWritable(true, false);
            logger.info("\u5df2\u8bbe\u7f6e\u5bc6\u94a5\u5e93\u6587\u4ef6\u6743\u9650");
        }
        catch (Exception e) {
            logger.error("\u65e0\u6cd5\u521b\u5efa debug.keystore", (Throwable)e);
            throw new RuntimeException("\u65e0\u6cd5\u521b\u5efa debug.keystore: " + e.getMessage(), e);
        }
    }

    public String getKeystorePath() {
        return this.keystorePath;
    }
}

