/*
 * Decompiled with CFR 0.152.
 */
package com.apktoolscnm.apktoolcnm.service;

import com.apktoolscnm.apktoolcnm.model.LoginRequest;
import com.apktoolscnm.apktoolcnm.model.LoginResponse;
import com.apktoolscnm.apktoolcnm.service.AuthService;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class AuthService {
    @Value(value="${auth.enabled:true}")
    private boolean authEnabled;
    @Value(value="${auth.username:admin}")
    private String configuredUsername;
    @Value(value="${auth.password:admin123}")
    private String configuredPassword;
    @Value(value="${auth.session.timeout:3600}")
    private int sessionTimeout;
    private final Map<String, SessionInfo> activeSessions = new HashMap();

    public LoginResponse authenticate(LoginRequest request) {
        if (!this.authEnabled) {
            return new LoginResponse(true, "\u8ba4\u8bc1\u5df2\u7981\u7528", this.generateToken());
        }
        if (request.getUsername() == null || request.getPassword() == null) {
            return new LoginResponse(false, "\u7528\u6237\u540d\u548c\u5bc6\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (this.configuredUsername.equals(request.getUsername()) && this.configuredPassword.equals(request.getPassword())) {
            String token = this.generateToken();
            this.activeSessions.put(token, new SessionInfo(System.currentTimeMillis()));
            return new LoginResponse(true, "\u767b\u5f55\u6210\u529f", token);
        }
        return new LoginResponse(false, "\u7528\u6237\u540d\u6216\u5bc6\u7801\u9519\u8bef");
    }

    public boolean validateToken(String token) {
        if (!this.authEnabled) {
            return true;
        }
        if (token == null || token.isEmpty()) {
            return false;
        }
        SessionInfo session = (SessionInfo)this.activeSessions.get(token);
        if (session == null) {
            return false;
        }
        long currentTime = System.currentTimeMillis();
        if (currentTime - session.getLoginTime() > (long)this.sessionTimeout * 1000L) {
            this.activeSessions.remove(token);
            return false;
        }
        return true;
    }

    public void logout(String token) {
        this.activeSessions.remove(token);
    }

    private String generateToken() {
        return UUID.randomUUID().toString();
    }
}

