/*
 * Decompiled with CFR 0.152.
 */
package com.apktoolscnm.apktoolcnm.interceptor;

import com.apktoolscnm.apktoolcnm.service.AuthService;
import jakarta.servlet.http.Cookie;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;
import org.springframework.web.servlet.HandlerInterceptor;

@Component
public class AuthInterceptor
implements HandlerInterceptor {
    @Autowired
    private AuthService authService;
    @Value(value="${auth.enabled:true}")
    private boolean authEnabled;

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws IOException {
        String token;
        if (!this.authEnabled) {
            return true;
        }
        String requestURI = request.getRequestURI();
        if (requestURI.equals("/login.html") || requestURI.equals("/auth/login") || requestURI.equals("/auth/validate") || requestURI.startsWith("/static/") || requestURI.equals("/health")) {
            return true;
        }
        String authHeader = request.getHeader("Authorization");
        if (authHeader != null && authHeader.startsWith("Bearer ") && this.authService.validateToken(token = authHeader.substring(7))) {
            return true;
        }
        Cookie[] cookies = request.getCookies();
        if (cookies != null) {
            for (Cookie cookie : cookies) {
                if (!"auth_token".equals(cookie.getName()) || !this.authService.validateToken(cookie.getValue())) continue;
                return true;
            }
        }
        if (requestURI.startsWith("/apk/") || requestURI.startsWith("/config/")) {
            response.setStatus(401);
            response.setContentType("application/json");
            response.getWriter().write("{\"error\":\"\u672a\u6388\u6743\u8bbf\u95ee\",\"message\":\"\u8bf7\u5148\u767b\u5f55\"}");
            return false;
        }
        response.sendRedirect("/login.html");
        return false;
    }
}

