/*
 * Decompiled with CFR 0.152.
 */
package com.apktoolscnm.apktoolcnm.controller;

import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.client.RestTemplate;

@RestController
@RequestMapping(value={"/api/proxy"})
public class ProxyController {
    private static final Logger logger = LoggerFactory.getLogger(ProxyController.class);
    @Autowired
    private RestTemplate restTemplate;

    @GetMapping(value={"/background"})
    public ResponseEntity<Map<String, Object>> getBackgroundImage() {
        try {
            logger.info("\u6b63\u5728\u83b7\u53d6\u80cc\u666f\u56fe\u7247...");
            String url = "https://www.dmoe.cc/random.php?return=json";
            String response = (String)this.restTemplate.getForObject(url, String.class, new Object[0]);
            if (response != null && response.contains("\"code\":\"200\"")) {
                logger.info("\u80cc\u666f\u56fe\u7247\u83b7\u53d6\u6210\u529f");
                HashMap<String, String> result = new HashMap<String, String>();
                result.put("code", "200");
                int imgurlStart = response.indexOf("\"imgurl\":\"") + 10;
                int imgurlEnd = response.indexOf("\"", imgurlStart);
                if (imgurlStart > 9 && imgurlEnd > imgurlStart) {
                    String imgurl = response.substring(imgurlStart, imgurlEnd);
                    result.put("imgurl", imgurl);
                }
                int widthStart = response.indexOf("\"width\":\"") + 9;
                int widthEnd = response.indexOf("\"", widthStart);
                if (widthStart > 8 && widthEnd > widthStart) {
                    String width = response.substring(widthStart, widthEnd);
                    result.put("width", width);
                }
                int heightStart = response.indexOf("\"height\":\"") + 10;
                int heightEnd = response.indexOf("\"", heightStart);
                if (heightStart > 9 && heightEnd > heightStart) {
                    String height = response.substring(heightStart, heightEnd);
                    result.put("height", height);
                }
                return ResponseEntity.ok(result);
            }
            logger.warn("\u80cc\u666f\u56fe\u7247API\u8fd4\u56de\u65e0\u6548\u6570\u636e: {}", (Object)response);
            HashMap<String, String> errorResponse = new HashMap<String, String>();
            errorResponse.put("error", "\u80cc\u666f\u56fe\u7247\u6570\u636e\u65e0\u6548");
            errorResponse.put("message", "\u65e0\u6cd5\u83b7\u53d6\u6709\u6548\u7684\u80cc\u666f\u56fe\u7247");
            return ResponseEntity.badRequest().body(errorResponse);
        }
        catch (Exception e) {
            logger.error("\u83b7\u53d6\u80cc\u666f\u56fe\u7247\u5931\u8d25", (Throwable)e);
            HashMap<String, String> errorResponse = new HashMap<String, String>();
            errorResponse.put("error", "\u83b7\u53d6\u80cc\u666f\u56fe\u7247\u5931\u8d25");
            errorResponse.put("message", e.getMessage());
            return ResponseEntity.internalServerError().body(errorResponse);
        }
    }
}

