/*
 * Decompiled with CFR 0.152.
 */
package net.roseboy.classfinal.util;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import net.roseboy.classfinal.util.IoUtils;

public class JarUtils {
    public static final String[] DLE_FILES = new String[]{".DS_Store", "Thumbs.db"};

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String doJar(String jarDir, String targetJar) {
        File jarDirFile = new File(jarDir);
        ArrayList<File> files = new ArrayList<File>();
        IoUtils.listFile(files, jarDirFile);
        ZipOutputStream zos = null;
        FileOutputStream out = null;
        try {
            File jar = new File(targetJar);
            if (jar.exists()) {
                jar.delete();
            }
            out = new FileOutputStream(jar);
            zos = new ZipOutputStream(out);
            for (File file : files) {
                ZipEntry ze;
                if (JarUtils.isDel(file)) continue;
                String fileName = file.getAbsolutePath().substring(jarDirFile.getAbsolutePath().length() + 1);
                fileName = fileName.replace(File.separator, "/");
                if (file.isDirectory()) {
                    ze = new ZipEntry(fileName + "/");
                    ze.setTime(System.currentTimeMillis());
                    zos.putNextEntry(ze);
                    zos.closeEntry();
                    continue;
                }
                if (fileName.endsWith(".jar")) {
                    byte[] bytes = IoUtils.readFileToByte(file);
                    ZipEntry ze2 = new ZipEntry(fileName);
                    ze2.setMethod(0);
                    ze2.setSize(bytes.length);
                    ze2.setTime(System.currentTimeMillis());
                    ze2.setCrc(IoUtils.crc32(bytes));
                    zos.putNextEntry(ze2);
                    zos.write(bytes);
                    zos.closeEntry();
                    continue;
                }
                ze = new ZipEntry(fileName);
                ze.setTime(System.currentTimeMillis());
                zos.putNextEntry(ze);
                byte[] bytes = IoUtils.readFileToByte(file);
                zos.write(bytes);
                zos.closeEntry();
            }
        }
        catch (Exception e) {
            try {
                e.printStackTrace();
            }
            catch (Throwable throwable) {
                IoUtils.close(zos, out);
                throw throwable;
            }
            IoUtils.close(zos, out);
        }
        IoUtils.close(zos, out);
        return targetJar;
    }

    public static List<String> unJar(String jarPath, String targetDir) {
        return JarUtils.unJar(jarPath, targetDir, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<String> unJar(String jarPath, String targetDir, List<String> includeFiles) {
        ArrayList<String> list = new ArrayList<String>();
        File target = new File(targetDir);
        if (!target.exists()) {
            target.mkdirs();
        }
        Object fin = null;
        ZipFile zipFile = null;
        try {
            File targetFile;
            ZipEntry entry;
            zipFile = new ZipFile(new File(jarPath));
            Enumeration<? extends ZipEntry> entries = zipFile.entries();
            while (entries.hasMoreElements()) {
                entry = entries.nextElement();
                if (entry.isDirectory()) {
                    targetFile = new File(target, entry.getName());
                    if (targetFile.exists()) continue;
                    targetFile.mkdirs();
                    continue;
                }
                int lastSeparatorIndex = entry.getName().lastIndexOf(File.separator);
                if (lastSeparatorIndex <= 0 || (targetFile = new File(target, entry.getName().substring(0, lastSeparatorIndex))).exists()) continue;
                targetFile.mkdirs();
            }
            entries = zipFile.entries();
            while (entries.hasMoreElements()) {
                entry = entries.nextElement();
                if (entry.isDirectory()) continue;
                targetFile = new File(target, entry.getName());
                if (includeFiles != null && includeFiles.size() > 0 && !includeFiles.contains(targetFile.getName())) continue;
                byte[] bytes = IoUtils.toBytes(zipFile.getInputStream(entry));
                IoUtils.writeFile(targetFile, bytes);
                list.add(targetFile.getAbsolutePath());
            }
        }
        catch (Exception e) {
            try {
                e.printStackTrace();
            }
            catch (Throwable throwable) {
                IoUtils.close(zipFile, fin);
                throw throwable;
            }
            IoUtils.close(zipFile, fin);
        }
        IoUtils.close(zipFile, fin);
        return list;
    }

    public static String releaseFileFromJar(File zip, String fileName, File targetFile) {
        byte[] bytes = JarUtils.getFileFromJar(zip, fileName);
        if (bytes == null) {
            return null;
        }
        IoUtils.writeFile(targetFile, bytes);
        return targetFile.getAbsolutePath();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static byte[] getFileFromJar(File zip, String fileName) {
        byte[] byArray;
        ZipEntry zipEntry;
        ZipFile zipFile;
        block7: {
            block6: {
                zipFile = null;
                if (zip.exists()) break block6;
                byte[] byArray2 = null;
                IoUtils.close(zipFile);
                return byArray2;
            }
            zipFile = new ZipFile(zip);
            zipEntry = zipFile.getEntry(fileName);
            if (zipEntry != null) break block7;
            byte[] byArray3 = null;
            IoUtils.close(zipFile);
            return byArray3;
        }
        try {
            InputStream is = zipFile.getInputStream(zipEntry);
            byArray = IoUtils.toBytes(is);
        }
        catch (IOException e) {
            try {
                e.printStackTrace();
            }
            catch (Throwable throwable) {
                IoUtils.close(zipFile);
                throw throwable;
            }
            IoUtils.close(zipFile);
            return null;
        }
        IoUtils.close(zipFile);
        return byArray;
    }

    public static boolean isDel(File file) {
        for (String f : DLE_FILES) {
            if (!file.getAbsolutePath().endsWith(f)) continue;
            return true;
        }
        return false;
    }

    public static String getRootPath(String path) {
        if (path == null) {
            path = JarUtils.class.getResource("").getPath();
        }
        try {
            path = URLDecoder.decode(path, "utf-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        if (path.startsWith("jar:") || path.startsWith("war:")) {
            path = path.substring(4);
        }
        if (path.startsWith("file:")) {
            path = path.substring(5);
        }
        if (path.contains("*")) {
            return path.substring(0, path.indexOf("*"));
        }
        if (path.contains("WEB-INF")) {
            return path.substring(0, path.indexOf("WEB-INF"));
        }
        if (path.contains("!")) {
            return path.substring(0, path.indexOf("!"));
        }
        if (path.endsWith(".jar") || path.endsWith(".war")) {
            return path;
        }
        if (path.contains("/classes/")) {
            return path.substring(0, path.indexOf("/classes/") + 9);
        }
        return null;
    }
}

